% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookfor.R
\name{look_for}
\alias{look_for}
\alias{lookfor}
\alias{generate_dictionary}
\alias{print.look_for}
\alias{look_for_and_select}
\alias{convert_list_columns_to_character}
\alias{lookfor_to_long_format}
\title{Look for keywords variable names and descriptions / Create a data dictionary}
\source{
Inspired by the \code{lookfor} command in Stata.
}
\usage{
look_for(
  data,
  ...,
  labels = TRUE,
  values = TRUE,
  ignore.case = TRUE,
  details = c("basic", "none", "full")
)

lookfor(
  data,
  ...,
  labels = TRUE,
  values = TRUE,
  ignore.case = TRUE,
  details = c("basic", "none", "full")
)

generate_dictionary(
  data,
  ...,
  labels = TRUE,
  values = TRUE,
  ignore.case = TRUE,
  details = c("basic", "none", "full")
)

\method{print}{look_for}(x, ...)

look_for_and_select(
  data,
  ...,
  labels = TRUE,
  values = TRUE,
  ignore.case = TRUE
)

convert_list_columns_to_character(x)

lookfor_to_long_format(x)
}
\arguments{
\item{data}{a data frame or a survey object}

\item{...}{optional list of keywords, a character string (or several
character strings), which can be formatted as a regular expression suitable
for a \code{\link[base:grep]{base::grep()}} pattern, or a vector of keywords;
displays all variables if not specified}

\item{labels}{whether or not to search variable labels (descriptions);
\code{TRUE} by default}

\item{values}{whether or not to search within values (factor levels or value
labels); \code{TRUE} by default}

\item{ignore.case}{whether or not to make the keywords case sensitive;
\code{TRUE} by default (case is ignored during matching)}

\item{details}{add details about each variable (full details could be time
consuming for big data frames, \code{FALSE} is equivalent to \code{"none"}
and \code{TRUE} to \code{"full"})}

\item{x}{a tibble returned by \code{look_for()}}
}
\value{
a tibble data frame featuring the variable position, name and
description (if it exists) in the original data frame
}
\description{
\code{look_for} emulates the \code{lookfor} Stata command in \R. It supports
searching into the variable names of regular \R data frames as well as into
variable labels descriptions, factor levels and value labels.
The command is meant to help users finding variables in large datasets.
}
\details{
When no keyword is provided, it will produce a data dictionary of the overall
data frame.

The function looks into the variable names for matches to the
keywords. If available, variable labels are included in the search scope.
Variable labels of data.frame imported with \pkg{foreign} or
\pkg{memisc} packages will also be taken into account (see \code{\link[=to_labelled]{to_labelled()}}).
If no keyword is provided, it will return all variables of \code{data}.

\code{look_for()}, \code{lookfor()} and \code{generate_dictionary()} are equivalent.

By default, results will be summarized when printing. To deactivate default
printing, use \code{dplyr::as_tibble()}.

\code{lookfor_to_long_format()} could be used to transform results with one row
per factor level and per value label.

Use \code{convert_list_columns_to_character()} to convert named list columns into
character vectors (see examples).

\code{look_for_and_select()} is a shortcut for selecting some variables and
applying \code{dplyr::select()} to return a data frame with only the selected
variables.
}
\examples{
look_for(iris)

# Look for a single keyword.
look_for(iris, "petal")
look_for(iris, "s")
iris \%>\%
  look_for_and_select("s") \%>\%
  head()

# Look for with a regular expression
look_for(iris, "petal|species")
look_for(iris, "s$")

# Look for with several keywords
look_for(iris, "pet", "sp")
look_for(iris, "pet", "sp", "width")
look_for(iris, "Pet", "sp", "width", ignore.case = FALSE)

# Look_for can search within factor levels or value labels
look_for(iris, "vers")

# Quicker search without variable details
look_for(iris, details = "none")

# To obtain more details about each variable
look_for(iris, details = "full")

# To deactivate default printing, convert to tibble
look_for(iris, details = "full") \%>\%
  dplyr::as_tibble()

# To convert named lists into character vectors
look_for(iris) \%>\% convert_list_columns_to_character()

# Long format with one row per factor and per value label
look_for(iris) \%>\% lookfor_to_long_format()

# Both functions can be combined
look_for(iris) \%>\%
  lookfor_to_long_format() \%>\%
  convert_list_columns_to_character()

# Labelled data
d <- dplyr::tibble(
  region = labelled_spss(
    c(1, 2, 1, 9, 2, 3),
    c(north = 1, south = 2, center = 3, missing = 9),
    na_values = 9,
    label = "Region of the respondent"
  ),
  sex = labelled(
    c("f", "f", "m", "m", "m", "f"),
    c(female = "f", male = "m"),
    label = "Sex of the respondent"
  )
)
look_for(d)
d \%>\%
  look_for() \%>\%
  lookfor_to_long_format() \%>\%
  convert_list_columns_to_character()
}
\author{
François Briatte \href{mailto:f.briatte@gmail.com}{f.briatte@gmail.com},
Joseph Larmarange \href{mailto:joseph@larmarange.net}{joseph@larmarange.net}
}
