% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_labelled.R
\name{to_labelled}
\alias{to_labelled}
\alias{to_labelled.data.frame}
\alias{to_labelled.list}
\alias{to_labelled.data.set}
\alias{to_labelled.importer}
\alias{foreign_to_labelled}
\alias{memisc_to_labelled}
\alias{to_labelled.factor}
\title{Convert to labelled data}
\usage{
to_labelled(x, ...)

\method{to_labelled}{data.frame}(x, ...)

\method{to_labelled}{list}(x, ...)

\method{to_labelled}{data.set}(x, ...)

\method{to_labelled}{importer}(x, ...)

foreign_to_labelled(x)

memisc_to_labelled(x)

\method{to_labelled}{factor}(x, labels = NULL, .quiet = FALSE, ...)
}
\arguments{
\item{x}{Factor or dataset to convert to labelled data frame}

\item{...}{Not used}

\item{labels}{When converting a factor only:
an optional named vector indicating how factor levels should be coded.
If a factor level is not found in \code{labels}, it will be converted to \code{NA}.}

\item{.quiet}{do not display warnings for prefixed factors with duplicated codes}
}
\value{
A tbl data frame or a labelled vector.
}
\description{
Convert a factor or data imported with \pkg{foreign} or \pkg{memisc} to labelled data.
}
\details{
\code{to_labelled()} is a general wrapper calling the appropriate sub-functions.

\code{memisc_to_labelled()} converts a \code{\link[memisc:dataSets]{memisc::data.set()}} object created with
\pkg{memisc} package to a labelled data frame.

\code{foreign_to_labelled()} converts data imported with \code{\link[foreign:read.spss]{foreign::read.spss()}}
or \code{\link[foreign:read.dta]{foreign::read.dta()}} from \pkg{foreign} package to a labelled data frame,
i.e. using \code{\link[haven:labelled]{haven::labelled()}}.
Factors will not be converted. Therefore, you should use \code{use.value.labels = FALSE}
when importing with \code{\link[foreign:read.spss]{foreign::read.spss()}} or \code{convert.factors = FALSE} when
importing with \code{\link[foreign:read.dta]{foreign::read.dta()}}.

To convert correctly defined missing values imported with \code{\link[foreign:read.spss]{foreign::read.spss()}}, you should
have used \code{to.data.frame = FALSE} and \code{use.missings = FALSE}. If you used the option
\code{to.data.frame = TRUE}, meta data describing missing values will not be attached to the import.
If you used \code{use.missings = TRUE}, missing values would have been converted to \code{NA}.

So far, missing values defined in \strong{Stata} are always imported as \code{NA} by
\code{\link[foreign:read.dta]{foreign::read.dta()}} and could not be retrieved by \code{foreign_to_labelled()}.

If you convert a labelled vector into a factor with prefix, i.e. by using
\link[=to_factor]{to_factor(levels = "prefixed")}, \code{to_labelled.factor()} is able to reconvert
it to a labelled vector with same values and labels.
}
\examples{
\dontrun{
  # from foreign
  library(foreign)
  sav <- system.file("files", "electric.sav", package = "foreign")
  df <- to_labelled(read.spss(
    sav,
    to.data.frame = FALSE,
    use.value.labels = FALSE,
    use.missings = FALSE
 ))

 # from memisc
 library(memisc)
 nes1948.por <- UnZip('anes/NES1948.ZIP', 'NES1948.POR', package='memisc')
 nes1948 <- spss.portable.file(nes1948.por)
 df <- to_labelled(nes1948)
 ds <- as.data.set(nes19480)
 df <- to_labelled(ds)
}

# Converting factors to labelled vectors
f <- factor(c("yes", "yes", "no", "no", "don't know", "no", "yes", "don't know"))
to_labelled(f)
to_labelled(f, c("yes" = 1, "no" = 2, "don't know" = 9))
to_labelled(f, c("yes" = 1, "no" = 2))
to_labelled(f, c("yes" = "Y", "no" = "N", "don't know" = "DK"))

s1 <- labelled(c('M', 'M', 'F'), c(Male = 'M', Female = 'F'))
labels <- val_labels(s1)
f1 <- to_factor(s1)
f1

to_labelled(f1)
identical(s1, to_labelled(f1))
to_labelled(f1, labels)
identical(s1, to_labelled(f1, labels))

l <- labelled(c(1, 1, 2, 2, 9, 2, 1, 9), c("yes" = 1, "no" = 2, "don't know" = 9))
f <- to_factor(l, levels = "p")
f
to_labelled(f)
identical(to_labelled(f), l)
}
\seealso{
\code{\link[haven:labelled]{haven::labelled()}}, \code{\link[foreign:read.spss]{foreign::read.spss()}},
\code{\link[foreign:read.dta]{foreign::read.dta()}}, \code{\link[memisc:dataSets]{memisc::data.set()}},
\link[memisc:importers]{memisc::importer}, \code{\link[=to_factor]{to_factor()}}.
}
