\name{quantize}
\alias{quantize}
\title{Force values into a set of bins}
\arguments{
  \item{x}{A sequence}

  \item{bins}{The bins to quantize into}

  \item{metric}{The method to attract values to the bins}
}
\value{
  A vector containing quantized data
}
\description{
  This function quantizes data into a set of bins based on
  a metric function. Each value in the input is evaluated
  with each quantization level (the bin), and the level
  with the smallest distance is assigned to the input
  value.
}
\section{Usage}{
  quantize(x, bins=c(-1,0,1), metric=function(a,b)
  abs(a-b))
}

\section{Details}{
  When converting analog signals to digital signals,
  quantization is a natural phenomenon. This concept can be
  extended to contexts outside of DSP. More generally it
  can be thought of as a way to classify a sequence of
  numbers according to some arbitrary distance function.

  The default distance function is the Euclidean distance
  in 1 dimension. For the default set of bins, values from
  (-infty, -.5] will map to -1. The values from (-.5, .5]
  map to 0, and the segment (.5, infty) map to 1.
  Regardless of the ordering of the bins, this behavior is
  guaranteed. Hence for a collection of boundary points k
  and bins b, where |b| = |k| + 1, the mapping will always
  have the form (-infty, k_1] => b_1, (k_1, k_2] => b_2,
  ... (k_n, infty) => b_n.
}
\examples{
x <- seq(-2, 2, by=.1)
quantize(x)

quantize(x, bins=-1.5:1.5)
}
\author{
  Brian Lee Yung Rowe
}
\seealso{
  \code{\link{confine}}
}

