% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-html.R
\name{html_response}
\alias{html_response}
\title{Prepare a HTML response for a Lambda behind an API Gateway}
\usage{
html_response(
  body,
  is_base64 = FALSE,
  status_code = 200L,
  content_type = NULL,
  headers = list()
)
}
\arguments{
\item{body}{the actual result to be delivered. This is not serialised in any
way, so if this is a list to be interpreted JSON it should be
stringified, that is, it should be a string of a JSON. Consider using the
\code{\link{as_stringified_json}} function.}

\item{is_base64}{logical which indicates if \code{body} is Base64 encoded.
Defaults to False.}

\item{status_code}{integer status code of the response. Defaults to \code{200L}
(OK).}

\item{content_type}{MIME type for the content. This will be appended to the
headers (as "Content-Type"), unless such a value is already provided to
\code{headers}, in which case this argument is ignored. If not provided then no
information on headers will be sent in the response, leaving the beahviour
up to the defaults of the API Gateway.}

\item{headers}{additional headers, as a named list, to be included in the
response. If this contains a "Content-Type" value then \code{content_type} is
ignored.}
}
\value{
A stringified JSON response for an API Gateway, with the
"already_serialised" attribute marked as \code{TRUE}. This will stop
\code{serialise_result} from attempting to serialise the result again.
}
\description{
Lambdas behind API Gateways need to send specially formatted responses that
look like this:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "statusCode": 200,
  "headers": \{
    "Content-Type": "application/json"
  \},
  "isBase64Encoded": false,
  "body": "\{\\"best_animal\\": \\"corgi\\"\}"
\}
}\if{html}{\out{</div>}}

For basic applications where the handler function is returning a simple
result, \code{lambdr} will do its best to automatically return a result compatible
with API Gateways. It will do this whenever an event is detected as having
come via an API Gateway. For most purposes this is sufficient, and allows
users to focus on the handler function rather than the specifics of how
\emph{AWS Lambda} works.

For more complicated applications, such as when the Lambda needs to return a
specific content type or specific headers, may require a bespoke response.
This function will take any R object and format it in style of the above
example, allowing for customisation.

When the handler function returns a \code{html_response} the formatted result will
be returned to the API Gateway without further serialisation.
}
\examples{
html_response("abc")
html_response("YWJj", is_base64 = TRUE)
html_response("abc", headers = list(x = "a"))
html_response(
  "<html><body>Hello World!</body></html>",
  content_type = "text/html"
)
}
