% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeClass.R
\name{makeClass}
\alias{makeClass}
\title{Create a class of patches.}
\usage{
makeClass(context, npatch, size, pts = NULL, bgr = 0, edge = FALSE,
  rast = TRUE, val = 1)
}
\arguments{
\item{context}{Raster object, a raster of an empty landscape or a mask, indicating where the patch cannot be generated (see \code{bgr} argument).}

\item{npatch}{number of patches per class}

\item{size}{integer. The size of patches, as number of raster cells. A single integer can be provided, in which case all patches will have that size.}

\item{pts}{integer or matrix. The seed point location around which the patches are built (random points are given by default). It can be an integer, as indeces of the cells in the raster, or a two columns matrix indicating x and y coordinates.}

\item{bgr}{integer. Value of background cells, where a patch can be generated (default is zero). Cells/classes which cannot be changed must have a different value.}

\item{edge}{logical. Should the vector of edge cells of the patch be returned?}

\item{rast}{logical. If TRUE returns a Raster object, otherwise a vector of cell numbers where the patch occurs}

\item{val}{integer. The value to be assigned to patch cells, when \code{rast=TRUE}}
}
\value{
A vector of matrix cell numbers, or an raster object if \code{rast=TRUE}.
}
\description{
Create a class of patches.
}
\details{
The patches created can be contiguous, therefore resembling a single patch with size
equal to the sum of contiguous cells.
}
\examples{
library(raster)

m = matrix(0, 33, 33)
r = raster(m, xmn=0, xmx=10, ymn=0, ymx=10)
num = 5
size = 15
rr = makeClass(r, num, size)
plot(rr)

## Create a class of three patches of given size at three corners of the spatial context
size = c(10, 50, 200)
pts = c(1, 33, 1089)
rr = makeClass(r, 3, size, pts)
plot(rr)
}

