% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_lsi.R
\name{lsm_l_lsi}
\alias{lsm_l_lsi}
\alias{lsm_l_lsi.RasterLayer}
\alias{lsm_l_lsi.RasterStack}
\alias{lsm_l_lsi.RasterBrick}
\alias{lsm_l_lsi.list}
\title{LSI (landscape level)}
\usage{
lsm_l_lsi(landscape, directions)

\method{lsm_l_lsi}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_lsi}{RasterStack}(landscape, directions = 8)

\method{lsm_l_lsi}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_lsi}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Landscape shape index (Aggregation metric)
}
\details{
\deqn{LSI = \frac{E} {\min E}}
where \eqn{E} is the total edge length in cell surfaces and \eqn{\min E}
is the minimum total edge length in cell surfaces

LSI is an 'Aggregation metric'. It is the ratio between the actual landscape edge length
and the hypothetical minimum edge length. The minimum edge length equals
the edge length if only one patch would be present.

\subsection{Units}{None}
\subsection{Ranges}{LSI >= 1}
\subsection{Behaviour}{Equals LSI = 1 when only one squared patch is present.
Increases, without limit, as the length of the actual edges increases, i.e.
the patches become less compact.}
}
\examples{
lsm_l_lsi(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_p_shape}}, \cr
\code{\link{lsm_c_lsi}}
}
