% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_ndca.R
\name{lsm_l_ndca}
\alias{lsm_l_ndca}
\alias{lsm_l_ndca.RasterLayer}
\alias{lsm_l_ndca.RasterStack}
\alias{lsm_l_ndca.RasterBrick}
\alias{lsm_l_ndca.stars}
\alias{lsm_l_ndca.list}
\title{NDCA (landscape level)}
\usage{
lsm_l_ndca(landscape, directions, consider_boundary, edge_depth)

\method{lsm_l_ndca}{RasterLayer}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)

\method{lsm_l_ndca}{RasterStack}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)

\method{lsm_l_ndca}{RasterBrick}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)

\method{lsm_l_ndca}{stars}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)

\method{lsm_l_ndca}{list}(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Number of disjunct core areas (Core area metric)
}
\details{
\deqn{NDCA = \sum \limits_{i = 1}^{m} \sum \limits_{j = 1}^{n} n_{ij}^{core}}
where \eqn{n_{ij}^{core}} is the number of disjunct core areas.

NDCA is a 'Core area metric'. The metric summarises the landscape as the sum of all
patches in the landscape. A cell is defined as core if the cell has no
neighbour with a different value than itself (rook's case). NDCA counts the disjunct
core areas, whereby a core area is a 'patch within the patch' containing only core cells.
It describes patch area and shape simultaneously (more core area when the patch is large,
however, the shape must allow disjunct core areas). Thereby, a compact shape (e.g. a square)
will contain less disjunct core areas than a more irregular patch.

\subsection{Units}{None}
\subsection{Range}{NDCA >= 0}
\subsection{Behaviour}{NDCA = 0 when TCA = 0, i.e. every cell in the landscape is
an edge cell. NDCA increases, with out limit, as core area increases and patch shapes allow
disjunct core areas (i.e. patch shapes become rather complex).}
}
\examples{
lsm_l_ndca(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_c_tca}}, \cr
\code{\link{lsm_p_ncore}},
\code{\link{lsm_c_ndca}}
}
