% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_core.R
\name{lsm_p_core}
\alias{lsm_p_core}
\title{CORE (patch level)}
\usage{
lsm_p_core(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Core area (Core area metric)
}
\details{
\deqn{CORE = a_{ij}^{core}}
where \eqn{a_{ij}^{core}} is the core area in square meters

CORE is a 'Core area metric' and equals the area within a patch that is not
on the edge of it. A cell is defined as core area if the cell has no
neighbour with a different value than itself (rook's case). It describes patch area
and shape simultaneously (more core area when the patch is large and the shape is
rather compact, i.e. a square).

\subsection{Units}{Hectares}
\subsection{Range}{CORE >= 0}
\subsection{Behaviour}{Increases, without limit, as the patch area increases
and the patch shape simplifies (more core area). CORE = 0 when every cell in
the patch is an edge.}
}
\examples{
lsm_p_core(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/
}
\seealso{
\code{\link{lsm_c_core_mn}},
\code{\link{lsm_c_core_sd}},
\code{\link{lsm_c_core_cv}},
\code{\link{lsm_c_tca}}, \cr
\code{\link{lsm_l_core_mn}},
\code{\link{lsm_l_core_sd}},
\code{\link{lsm_l_core_cv}},
\code{\link{lsm_l_tca}}
}
