% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_enn_cv.R
\name{lsm_c_enn_cv}
\alias{lsm_c_enn_cv}
\title{ENN_CV (class level)}
\usage{
lsm_c_enn_cv(landscape, directions = 8, verbose = TRUE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}

\item{verbose}{Print warning message if not sufficient patches are present}
}
\value{
tibble
}
\description{
Coefficient of variation of euclidean nearest-neighbor distance (Aggregation metric)
}
\details{
\deqn{ENN_{CV} = cv(ENN[patch_{ij}])}
where \eqn{ENN[patch_{ij}]} is the euclidean nearest-neighbor distance
of each patch.

ENN_CV is an 'Aggregation metric'. It summarises each class as the Coefficient
of variation of each patch belonging to class i. ENN measures the distance to the  nearest
neighbouring patch of the same class i. The distance is measured from edge-to-edge.
The range is limited by the cell resolution on the lower limit and the landscape extent
on the upper limit. The metric is a simple way to describe patch isolation. Because it is
scaled to the mean, it is easily comparable among different landscapes.

\subsection{Units}{Meters}
\subsection{Range}{ENN_CV >= 0}
\subsection{Behaviour}{Equals ENN_CV = 0 if the euclidean nearest-neighbor distance is
identical for all patches. Increases, without limit, as the variation of ENN increases.}
}
\examples{
lsm_c_enn_cv(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

McGarigal, K., and McComb, W. C. (1995). Relationships between landscape
structure and breeding birds in the Oregon Coast Range.
Ecological monographs, 65(3), 235-260.
}
\seealso{
\code{\link{lsm_p_enn}},
\code{\link{cv}}, \cr
\code{\link{lsm_c_enn_mn}},
\code{\link{lsm_c_enn_sd}}, \cr
\code{\link{lsm_l_enn_mn}},
\code{\link{lsm_l_enn_sd}},
\code{\link{lsm_l_enn_cv}}
}
