% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_shape.R
\name{lsm_p_shape}
\alias{lsm_p_shape}
\title{SHAPE (patch level)}
\usage{
lsm_p_shape(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Shape index (Shape metric)
}
\details{
\deqn{SHAPE = \frac{0.25 * p_{ij}} {\sqrt a_{ij}}}
where \eqn{p_{ij}} is the perimeter (m) and \eqn{a_{ij}} is the area (m2).

SHAPE is a 'Shape metric'. It describes the ratio between the actual perimeter of
the patch and the square root of patch area and thus adjusting for a square standard.
Thus, it is a simple measure of shape complexity.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{None}
\subsection{Range}{SHAPE >= 1}
\subsection{Behaviour}{Equals SHAPE = 1 for a squared patch and
increases, without limit, as the patch shape becomes more complex.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_p_shape(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_p_perim}},
\code{\link{lsm_p_area}}, \cr
\code{\link{lsm_c_shape_mn}},
\code{\link{lsm_c_shape_sd}},
\code{\link{lsm_c_shape_cv}}, \cr
\code{\link{lsm_l_shape_mn}},
\code{\link{lsm_l_shape_sd}},
\code{\link{lsm_l_shape_cv}}
}
