#' util_calc_boundaries
#'
#' @description Determine upper class boundaries for classification of a vector with values ranging 0-1 based upon an
#' vector of cumulative proportions.
#'
#' @param x vector of data values.
#' @param cumulative_proportions Vector of class cumulative proportions, as generated by `w2cp`.
#'
#'
#' @return Numerical vector with boundaries for matrix classification
#'
#'
#' @examples
#' x <- matrix(runif(100,0,1),10,10)
#' y <- util_w2cp(c(0.5, 0.25, 0.25)) #cumulative proportion
#' util_calc_boundaries(x,y)
#'
#' @keywords internal
#' @export


util_calc_boundaries <- function(x, cumulative_proportions) {

  # remove na (e.g. if cells are masked from classify)
  if (any(is.na(x))) {
      x <- x[!is.na(x)]
  }

  # Get number of cells  ----
  n_cells <- length(x)

  # Use number of cells to find index of upper boundary element ----
  boundary_indexes <- as.integer( (cumulative_proportions * n_cells))

  # Get boundary values ----
  boundary_values <- sort(as.vector(x))[boundary_indexes]

  return(boundary_values)
}
