% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{loadCultivar}
\alias{loadCultivar}
\title{Load a cultivar}
\usage{
loadCultivar(name, type = "growingHost")
}
\arguments{
\item{name}{a character string (without space) specifying the cultivar name.}

\item{type}{the cultivar type: "growingHost", "nongrowingHost" or "nonCrop"
(default = "nonhost").}
}
\value{
a dataframe of parameters associated with each host genotype
(i.e. cultivars, lines) when cultivated in pure crops.
}
\description{
create a data.frame containing cultivar parameters depending of his type
}
\details{
\itemize{
\item "growingHost" is adapted to situations where the infection unit is a piece of leaf
(e.g. where a fungal lesion can develop); the number of available infection units
increasing during the season due to plant growth.
\item "nongrowingHost" corresponds to situations where the infection unit is the whole plant
(e.g. for viral systemic infection); thus the number of infection units is constant.
\item "nonCrop" is not planted, does not cost anything and does not yield anything
(e.g. forest, fallow).
}
}
\examples{
c1 <- loadCultivar("winterWheat", type = "growingHost")
c1
c2 <- loadCultivar("forest", type = "nonCrop")
c2
}
\seealso{
\link{setCultivars}
}
