% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setTreatment}
\alias{setTreatment}
\title{Set chemical treatments}
\usage{
setTreatment(params, treatment_params)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{treatment_params}{a list of treatment parameters including:
\itemize{
\item treatment_reduction_rate = reduction per time step of treatment concentration,
\item treatment_efficiency = maximal efficiency of chemical treatments (i.e. fractional reduction of pathogen infection rate at the application date),
\item treatment_timesteps = vector of time-steps corresponding to treatment application dates,
\item treatment_cultivars  = vector of cultivar indices that receive treatments,
\item treatment_cost = cost of a single treatment application (monetary units/ha)
}}
}
\value{
a LandsepiParams object
}
\description{
Updates a LandsepiParams object with treatment parameters
}
\details{
An empty list of treatments (i.e. absence of application) can be loaded using \code{\link{loadPathogen}}.
}
\examples{
\dontrun{
t <- loadTreatment()
simul_params <- setTreatment(simul_params, t)
simul_params@Treatment
}
}
\seealso{
\link{loadTreatment}
}
