% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Math-Functions.R
\name{multiN}
\alias{multiN}
\title{Allocation of cultivars}
\usage{
multiN(d, area, prop, range = 0, algo = "random")
}
\arguments{
\item{d}{a symmetric matrix of the pairwise distances between the centroids of the fields of the landscape.}

\item{area}{vector containing field areas.}

\item{prop}{proportion of landscape surface covered by the second type of crop.}

\item{range}{range of spatial autocorrelation between fields (must be greater or equal 0). The greater
the value of range, the higher the degree of spatial aggregation (roughly, range between 0 and 0.1 for
fragmented landscapes, between 0.1 and 0.5 for balanced
landscapes, between 0.5 and 3 for aggregated landscapes, and above 3 for highly aggregated landscapes).}

\item{algo}{the algorithm used for the computation of the variance-covariance matrix of the multivariate
normal distribution: "exp" for exponential function, "periodic" for periodic function,
"random" for random draw (see details). If algo="random", the parameter range is ignored.}
}
\value{
A dataframe containing the index of each field (column 1) and the index (0 or 1) of the type
of crop grown on these fields (column 2).
}
\description{
Algorithm based on latent Gaussian fields to allocate two different types of crops across
a landscape.
}
\details{
This algorithm allows the control of the proportions of each type of crop in terms of surface
coverage, and their level of spatial aggregation. A random vector of values is drawn from a multivariate
normal distribution with expectation 0 and a variance-covariance matrix which depends on the pairwise
distances between the centroids of the fields. Two different functions allow the computation of the
variance-covariance matrix to allocate crops with more or less spatial aggregation (depending on the
value of the range parameter). The exponential function codes for an exponential decay of the spatial
autocorrelation as distance between fields increases. The periodic function codes for a periodic fluctuation
of the spatial autocorrelation as distance between fields increases. Alternatively, a normal distribution
can be used for a random allocation of the types of crops.
Next, the two types of crops are allocated to different fields depending on whether
the value drawn from the multivariate normal distribution is above or below a threshold. The proportion
of each type of crop in the landscape is controlled by the value of this threshold (parameter prop).
}
\examples{
\dontrun{
d <- matrix(rpois(100, 100), nrow = 10)
d <- d + t(d) ## ensures that d is symmetric
area <- data.frame(id = 1:10, area = 10)
multiN(d, area, prop = 0.5, range = 0.5, algo = "periodic")
}
}
