% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrabble.R
\name{scrabble_words}
\alias{scrabble_words}
\title{Scrabble: Highest score words finder}
\usage{
scrabble_words(
  tiles,
  free = 0,
  force_start = "",
  force_end = "",
  force_str = "",
  force_n = 0,
  force_max = 0,
  scores = Sys.getenv("LARES_LANG"),
  language = Sys.getenv("LARES_LANG"),
  words = NA,
  quiet = FALSE
)
}
\arguments{
\item{tiles}{Character. The letters you wish to consider.}

\item{free}{Integer. How many free blank tiles you have?}

\item{force_start, force_end}{Character. Force words to start or end with
a pattern of letters and position. Examples: "S" or "SO" or "__S_O"...
If the string contains tiles that were not specified in \code{tiles}, they
will automatically be included.}

\item{force_str}{Character vector. Force words to contain strings.
If the string contains tiles that were not specified in \code{tiles}, they
will automatically be included.}

\item{force_n, force_max}{Integer. Force words to be n or max n characters 
long. Leave 0 to ignore parameter.}

\item{scores, language}{Character. Any of "en","es","de","fr". 
If scores is not any of those languages, must be a data.frame that 
contains two columns: "tiles" with every letter of the alphabet and 
"scores" for each letter's score. If you wish
to overwrite or complement this dictionaries other words you can set to
\code{"none"} and/or use the \code{words} parameter.
You might also want to set this parameter globally with
\code{Sys.setenv("LARES_LANG" = "en")} and forget about it!}

\item{words}{Character vector. Use if you wish to manually add words.}

\item{quiet}{Boolean. Do not print words as they are being searched.}
}
\value{
data.frame with matching words found, sorted by higher points.
}
\description{
Find highest score words given a set of letters, rules, and 
language to win at Scrabble! You just have to find the best 
place to post your tiles.
}
\examples{
\donttest{
# Automatic use of languages and scores
Sys.setenv("LARES_LANG" = "es")
scrabble_words(tiles = "hola",
               free = 2,
               force_start = "h",
               #force_end = "",
               force_str = "_o_a",
               force_n = 5,
               force_max = 0,
               quiet = TRUE)

# Words considered for a language (you can custom it too!)
es_words <- scrabble_dictionary("es")
}
}
\seealso{
Other Scrabble: 
\code{\link{scrabble_dictionary}()},
\code{\link{scrabble_points}()},
\code{\link{scrabble_score}()}
}
\concept{Scrabble}
