% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x2y.R
\name{x2y}
\alias{x2y}
\alias{x2y_metric}
\alias{plot.x2y_preds}
\alias{plot.x2y}
\alias{x2y_preds}
\title{Ranked Predictive Power of Cross-Features (x2y)}
\usage{
x2y(
  df,
  target = NULL,
  symmetric = FALSE,
  target_x = FALSE,
  target_y = FALSE,
  plot = FALSE,
  top = 20,
  quiet = "auto",
  ohse = FALSE,
  corr = FALSE,
  ...
)

x2y_metric(x, y, confidence = FALSE, bootstraps = 20, max_cat = 20)

\method{plot}{x2y_preds}(x, corr = FALSE, ...)

\method{plot}{x2y}(x, type = 1, ...)

x2y_preds(x, y, max_cat = 10)
}
\arguments{
\item{df}{data.frame. Note that variables with no variance will be ignored.}

\item{target}{Character vector. If you are only interested in the \code{x2y}
values between particular variable(s) in \code{df}, set
name(s) of the variable(s) you are interested in. Keep \code{NULL}
to calculate for every variable (column). Check \code{target_x} and
\code{target_y} parameters as well.}

\item{symmetric}{Boolean. \code{x2y} metric is not symmetric with respect to
\code{x} and \code{y}. The extent to which \code{x} can predict \code{y} can
be different from the extent to which \code{y} can predict \code{x}. Set
\code{symmetric=TRUE} if you wish to average both numbers.}

\item{target_x, target_y}{Boolean. Force target features to be part of
\code{x} OR \code{y}?}

\item{plot}{Boolean. Return a plot? If not, only a data.frame with calculated
results will be returned.}

\item{top}{Integer. Show/plot only top N predictive cross-features. Set
to \code{NULL} to return all.}

\item{quiet}{Boolean. Keep quiet? If not, show progress bar.}

\item{ohse}{Boolean. Use \code{lares::ohse()} to pre-process the data?}

\item{corr}{Boolean. Add correlation and pvalue data to compare with? For
more custom studies, use \code{lares::corr_cross()} directly.}

\item{...}{Additional parameters passed to \code{x2y_metric()}}

\item{x, y}{Vectors. Categorical or numerical vectors of same length.}

\item{confidence}{Boolean. Calculate 95\% confidence intervals estimated
with N \code{bootstraps}.}

\item{bootstraps}{Integer. If \code{confidence=TRUE}, how many bootstraps?
The more iterations we run the more precise the confidence internal will be.}

\item{max_cat}{Integer. Maximum number of unique \code{x} or \code{y} values
when categorical. Will select then most frequent values and the rest will
be passed as \code{""}.}

\item{type}{Integer. Plot type: \code{1} for tile plot,
\code{2} for ranked bar plot.}
}
\value{
Depending on \code{plot} input, a plot or a data.frame with x2y results.
}
\description{
The relative reduction in error when we go from a baseline model
(average for continuous and most frequent for categorical features) to
a predictive model, can measure the strength of the relationship between
two features. In other words, \code{x2y} measures the ability of \code{x}
to predict \code{y}. We use CART (Classification And Regression Trees) models
to be able to 1) compare numerical and non-numerical features, 2) detect
non-linear relationships, and 3) because they are easy/quick to train.
}
\details{
This \code{x2y} metric is based on Rama Ramakrishnan's 
\href{https://bit.ly/3sOVbei}{post}: An Alternative to the Correlation
Coefficient That Works For Numeric and Categorical Variables. This analysis
complements our \code{lares::corr_cross()} output.
}
\examples{
\donttest{
data(dft) # Titanic dataset
x2y_results <- x2y(dft, quiet = TRUE, max_cat = 10, top = NULL)
head(x2y_results, 10)
plot(x2y_results, type = 2)

# Confidence intervals with 10 bootstrap iterations
x2y(dft, target = c("Survived","Age"), 
    confidence = TRUE, bootstraps = 10, top = 8)

# Compare with mean absolute correlations
x2y(dft, "Fare", corr = TRUE, top = 6, target_x = TRUE)

# Plot (symmetric) results
symm <- x2y(dft, target = "Survived", symmetric = TRUE)
plot(symm, type = 1)

# Symmetry: x2y vs y2x
on.exit(set.seed(42))
x <- seq(-1, 1, 0.01)
y <- sqrt(1 - x^2) + rnorm(length(x), mean = 0, sd = 0.05)

# Knowing x reduces the uncertainty about the value of y a lot more than
# knowing y reduces the uncertainty about the value of x. Note correlation.
plot(x2y_preds(x, y), corr = TRUE)
plot(x2y_preds(y, x), corr = TRUE)
}
}
