% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{stocks_quote}
\alias{stocks_quote}
\title{Download Stocks Current Data}
\usage{
stocks_quote(ticks)
}
\arguments{
\item{ticks}{Character Vector. Symbols/Tickers to quote in real time.}
}
\value{
data.frame with Symbol, Type of stock, Quote time, current value,
Daily Change, Market, and Symbol Name.
}
\description{
This function lets the user download stocks live data.
}
\examples{
\donttest{
# Multiple quotes at the same time
stocks_quote(c("VTI","VOO","TSLA"))
}
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_report}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{holidays}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_hist}()},
\code{\link{trendsRelated}()},
\code{\link{writeGS}()}
}
\concept{Investment}
\concept{Scrapper}
