% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tictoc.R
\name{tic}
\alias{tic}
\alias{toc}
\title{Stopwatch to measure timings in R}
\usage{
tic(id = 1, start = proc.time()["elapsed"], quiet = TRUE)

toc(id = 1, msg = "Elapsed time:", type = "units", signif = 3, quiet = FALSE)
}
\arguments{
\item{id}{Define ID if multiple \code{tic} & \code{toc} are being used.}

\item{start}{Start time. Now is default.}

\item{quiet}{Boolean. Quiet messages?}

\item{msg}{Character. Custom message shown}

\item{type}{Character. Output format for \code{time} list element.
Choose any of: \code{units, clock, seconds}.}

\item{signif}{Integer. Significant digits}
}
\value{
Invisible list. Contains tic (start time), toc (stop time),
elapsed time and message printed.

\code{toc} returns an (invisible) list containing the time-stamps
\code{tic} and \code{toc}, \code{time} in seconds and the message \code{msg}.
}
\description{
Start a stopwatch.

Stop a stopwatch.
}
\examples{
# Basic use (global stopwatch)
tic()
Sys.sleep(0.1)
toc()

# Multiple tic tocs
tic(id = "two", quiet = FALSE)
Sys.sleep(0.2)
toc(id = "two")

# Global is still working (id = 1)
toc(msg = "The function finished its work in")
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{get_credentials}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}
}
\concept{Time}
\concept{Tools}
