% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrabble.R
\name{scrabble_dictionary}
\alias{scrabble_dictionary}
\alias{scrabble_score}
\alias{scrabble_points}
\alias{scrabble_words}
\title{Scrabble: Dictionaries}
\usage{
scrabble_dictionary(lang_dic, quiet = FALSE)

scrabble_score(words, scores.df)

scrabble_points(lang)

scrabble_words(
  tiles = "",
  free = 0,
  force_start = "",
  force_end = "",
  force_str = "",
  force_exclude = "",
  exclude_here = "",
  force_n = 0,
  force_max = 0,
  language = Sys.getenv("LARES_LANG"),
  scores = language,
  words = NULL,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{lang_dic}{Character. Any of "en","es","de","fr". Set to NULL
if you wish to skip this step (and use \code{words} parameter in
\code{scrabble_words} instead).}

\item{quiet}{Boolean. Do not print words as they are being searched.}

\item{words}{Character vector. Use if you wish to manually add words.}

\item{scores.df}{Dataframe. Must contain two columns: "tiles" with every
letter of the alphabet and "scores" for each letter's score.}

\item{lang}{Character. Any of "en","es". Set to NULL
if you wish to skip this step (and use \code{words} parameter in
\code{scrabble_words()} instead).}

\item{tiles}{Character. The letters you wish to consider.}

\item{free}{Integer. How many free blank tiles you have?}

\item{force_start, force_end}{Character. Force words to start or end with
a pattern of letters and position. Examples: "S" or "SO" or "__S_O"...
If the string contains tiles that were not specified in \code{tiles}, they
will automatically be included.}

\item{force_str}{Character vector. Force words to contain strings.
If the string contains tiles that were not specified in \code{tiles}, they
will automatically be included.}

\item{force_exclude, exclude_here}{Character vector. Exclude words containing
these tiles (and positions). Not very relevant on Scrabble but for Wordle.}

\item{force_n, force_max}{Integer. Force words to be n or max n characters
long. Leave 0 to ignore parameter.}

\item{scores, language}{Character. Any of "en","es","de","fr".
If scores is not any of those languages, must be a data.frame that
contains two columns: "tiles" with every letter of the alphabet and
"scores" for each letter's score. If you wish
to overwrite or complement this dictionaries other words you can set to
\code{"none"} and/or use the \code{words} parameter.
You might also want to set this parameter globally with
\code{Sys.setenv("LARES_LANG" = "en")} and forget about it!}

\item{print}{Boolean. Print how many words are left by step.}
}
\value{
data.frame with words and language columns.

data.frame with word, scores, and length values for each \code{word}.

data.frame with tiles and scores for each alphabet letter.

data.frame with matching words found, sorted by higher points.
}
\description{
Download words from 4 different languages: English, Spanish,
German, and French. Words will be save into the \code{temp} directory.
This is an auxiliary function. You may want to use \code{scrabble_words}
directly if you are searching for the highest score words!

Get score for any word or list of words. You may set manually depending
on the rules and languages you are playing with. Check the examples
for Spanish and English values when I played Words With Friends.

Dataframe for every letter and points given a language.

Find highest score words given a set of letters, rules, and
language to win at Scrabble! You just have to find the best
place to post your tiles.
}
\examples{
\donttest{
# For Spanish words
dictionary <- scrabble_dictionary("es")
}
\donttest{
# For Spanish words (default)
es_scores <- scrabble_points("es")
# Custom scores for each letter
cu_scores <- data.frame(
  tiles = tolower(LETTERS),
  scores = c(1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 5, 2, 4, 2, 1, 4, 10, 1, 1, 1, 2, 5, 4, 8, 3, 10)
)

# Score values for each set of rules
words <- c("Bernardo", "Whiskey", "R is great")
scrabble_score(words, es_scores)
scrabble_score(words, cu_scores)
}
scrabble_points("es")
scrabble_points("en")
# Not yet available
scrabble_points("fr")
\donttest{
# Automatic use of languages and scores
Sys.setenv("LARES_LANG" = "es")
scrabble_words(
  tiles = "hola",
  free = 2,
  force_start = "h",
  force_n = 4,
  force_str = "_o_a"
)

wordle <- c("board", "tempo", "shoes", "hoard")
scrabble_words(
  language = NULL,
  words = wordle,
  force_n = 5,
  force_str = "O_R"
)

# Words considered for a language (you can custom it too!)
es_words <- scrabble_dictionary("es")
}
}
\concept{Scrabble}
