% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mails.R
\name{mail_send}
\alias{mail_send}
\title{Send Emails with Attachments (POST)}
\usage{
mail_send(
  from = "RMail <laresbernardo@gmail.com>",
  to = "laresbernardo@gmail.com",
  cc = NULL,
  bcc = NULL,
  subject = "Mail from R",
  text = " \\n",
  html = NULL,
  attachment = NULL,
  service = "mailgun",
  creds = NULL,
  quiet = FALSE
)
}
\arguments{
\item{from, to, cc, bcc}{Character. Emails}

\item{subject}{Character. Subject for the email.}

\item{text, html}{Character. Text or HTML to send in the body.}

\item{attachment}{Character, plot or data.frame. Will send the file,
plot as PNG or data.frame as CSV, respectively.}

\item{service}{Character. Service platform to search on \code{creds}.}

\item{creds}{Character. Credential's user (see \code{get_creds()}).
Must contain: url (POST address), api (API key).}

\item{quiet}{Boolean. Keep quite or display messages?}
}
\value{
No return value, called for side effects.
}
\description{
This function lets the user send Emails with Attachments using MailGun's
API service.
}
\examples{
\dontrun{
myPlot <- noPlot("My plot")
mail_send(
  from = "BLV <myuser@mail.com>",
  to = "youruser@mail.com",
  cc = "myuser@mail.com",
  subject = paste("Daily report:", Sys.Date()),
  attachment = myPlot
)
}
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{get_credentials}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}

Other Credentials: 
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{get_credentials}()},
\code{\link{get_tweets}()},
\code{\link{queryDB}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()},
\code{\link{stocks_file}()},
\code{\link{stocks_report}()}
}
\concept{Credentials}
\concept{Tools}
