% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sudoku.R
\name{sudoku_solver}
\alias{sudoku_solver}
\title{Solve Sudoku Puzzles}
\usage{
sudoku_solver(board, needed_cells = NULL, index = 1, quiet = FALSE)
}
\arguments{
\item{board}{Matrix. 9x9 matrix or vector length 81, with only digits from 0 to 9.}

\item{needed_cells, index}{Auxiliary parameters to auto-iterate using this same fx.}

\item{quiet}{Boolean. Keep quiet? If not, plot results.}
}
\value{
Logical output answering of the input board can be solved. The
actual solved solution will be created as an object named \code{solved}
in your \code{.GlobalEnv}.
}
\description{
Solve a Sudoku puzzle, where empty values are represented by 0s
into a matrix object.
}
\examples{
\donttest{
# board <- c(0,0,0,0,0,6,000,
#            0,9,5,7,0,0,3,0,0,
#            4,0,0,0,9,2,0,0,5,
#            7,6,4,0,0,0,0,0,3,
#            0,0,0,0,0,0,0,0,0,
#            2,0,0,0,0,0,9,7,1,
#            5,0,0,2,1,0,0,0,9,
#            0,0,7,0,0,5,4,8,0,
#            0,0,0,8,0,0,0,0,0)
# sudoku_solver(board)

# Trivial input (everything)
trivial <- matrix(rep(0, 81), byrow = TRUE, ncol = 9)
trivial
sudoku_solver(trivial)

# Wrong / Impossible to solve input
imp <- matrix(c(rep(1, 72), rep(0, 9)), byrow = TRUE, ncol = 9)
imp
sudoku_solver(imp)
}
}
