% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrogram.R
\name{as.dendrogram.hdbscan}
\alias{as.dendrogram.hdbscan}
\title{as.dendrogram.hdbscan}
\usage{
\method{as.dendrogram}{hdbscan}(object, includeNodes = FALSE, ...)
}
\arguments{
\item{object}{An \code{hdbscan} object.}

\item{includeNodes}{Whether individual nodes should be included in the dedrogram. Can cause a substantial increase in the size of the object.}

\item{...}{For compatibility with \code{\link[stats]{as.dendrogram}}, and currently ignored.}
}
\value{
A \code{dendrogram} object, where nodes have the following attributes:
\describe{
\item{'leaf'}{As in \code{\link[stats]{dendrogram}}.}
\item{'members'}{As in \code{\link[stats]{dendrogram}}.}
\item{'size'}{The number of nodes underneath the cluster.}
\item{'height'}{The core distance at which the cluster or node was merged.}
\item{'probability'}{The probability that the leaf is a true member of its assigned cluster.}
\item{'GLOSH'}{The leaf's GLOSH outlier score.}
\item{'stability'}{The node's determined stability, taking into account child-node stabilities. Missing for leaves.}
\item{'selected'}{Whether the node was selected as a cluster.  Missing for leaves.  Note that when a node is selected,
all points under child branches are assigned to the same cluster.}
\item{'cluster'}{The cluster number, for reference against the \code{hdbscan} object.}
}
}
\description{
Convert an hdbscan object into a dendrogram compatible with the \code{stats} package.
}
\note{
The hdbscan algorithm works by first building a hierarchy based on a minimal spanning tree, then consolidating nodes according to
rules in the algorithm. The algorithm then selects some of the consolidated nodes as clusters, deselecting others. For example, if Node A has children
B and C, the algorithm might select A, and then all points under A, B, and C would be assigned to the same cluster. Or, it might deselect A,
and select B and C instead. In that case, the nodes under B would be assigned to one cluster, the nodes under C to a different cluster, and nodes
under A but not B or C would not be assigned to any cluster. This function returns a dendrogram of the middle stage, the hierarchy of consolidated
nodes. Whether a node was selected as as cluster is an attribute of each node.

This function remains experimental in terms of finding the best way to represent an hdbscan object in a dendrogram.
}
\examples{
\dontrun{
data(iris)
vis <- largeVis(t(iris[,1:4]), K = 20, sgd_batches = 1)
hdbscanobj <- hdbscan(vis, minPts = 10, K = 5)
plot(as_dendrogram_hdbscan(hdbscanobj))
}
}
