% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estR.R
\name{estR}
\alias{estR}
\title{Estimate latent correlation for mixed types.}
\usage{
estR(
  X,
  types = "con",
  method = c("approx", "original"),
  nu = 0.001,
  tol = 1e-08,
  ratio = 0.9,
  showplot = FALSE
)
}
\arguments{
\item{X}{A numeric data matrix (n by p), where n is number of samples, and p is number of variables. Missing values (NA) are allowed, in which case the estimation is based on pairwise complete observations.}

\item{types}{A vector of length p indicating the type of each of the p variables in \code{X}. Each element must be one of \code{"con"} (continuous), \code{"bin"} (binary), \code{"tru"} (truncated) or \code{"ter"} (ternary). If the vector has length 1, then all p variables are assumed to be of the same type that is supplied. The default value is \code{"con"} which means all variables are continuous.}

\item{method}{The calculation method for latent correlations. Either \code{"original"} or \code{"approx"}. If \code{method = "approx"}, multilinear approximation method is used, which is much faster than the original method. If \code{method = "original"}, optimization of the bridge inverse function is used. The default is \code{"approx"}.}

\item{nu}{Shrinkage parameter for the correlation matrix, must be between 0 and 1, the default value is 0.001.}

\item{tol}{Desired accuracy when calculating the solution of bridge function. The default value is 1e-8.}

\item{ratio}{The boundary value for multilinear interpolation, must be between 0 and 1, the default value is 0.9. If \code{method = "original"}, this parameter is ignored.}

\item{showplot}{Logical indicator. \code{showplot = TRUE} generates a ggplot object \code{plotR} with the heatmap of latent correlation matrix \code{R}. \code{plotR = NULL} if \code{showplot = FALSE}.}
}
\value{
\code{estR} returns
\itemize{
      \item{zratios: }{A list of of length p corresponding to each variable. Returns NA for continuous variable; proportion of zeros for binary/truncated variables; the cumulative proportions of zeros and ones (e.g. first value is proportion of zeros, second value is proportion of zeros and ones) for ternary variable. }
      \item{K: }{(p x p) Kendall Tau (Tau-a) Matrix for \code{X} }
      \item{R: }{(p x p) Estimated latent correlation matrix for \code{X} }
      \item{Rpointwise: }{(p x p) Point-wise estimates of latent correlations for \code{X}. This matrix is not guaranteed to be semi-positive definite. If it is however, and if \code{nu=0}, then it will be the same as \code{R}.}
      \item{plotR: }{Heatmap plot of latent correlation matrix \code{R}, NULL if \code{showplot = FALSE}}
}
}
\description{
Estimation of latent correlation matrix from observed data of (possibly) mixed types (continuous/binary/truncated/ternary) based on the latent Gaussian copula model. Missing values (NA) are allowed. The estimation is based on pairwise complete observations.
}
\examples{
# Data generation
X = GenData()$X
# Estimate latent correlation matrix with original method
R_nc_org = estR(X = X, types = c("ter", "con"), method = "original")$R
# Estimate latent correlation matrix with aprroximation method
R_nc_approx = estR(X = X, types = c("ter", "con"), method = "approx")$R
# Heatmap for latent correlation matrix.
Heatmap_R_nc_approx = estR(X = X, types = c("ter", "con"), method = "approx", showplot = TRUE)$plotR
}
\references{
Fan J., Liu H., Ning Y. and Zou H. (2017) "High dimensional semiparametric latent graphicalmodel for mixed data" \doi{10.1111/rssb.12168}.

Yoon G., Carroll R.J. and Gaynanova I. (2020) "Sparse semiparametric canonical correlation analysis for data of mixed types" \doi{10.1093/biomet/asaa007}.

Yoon G., Müller C.L., Gaynanova I. (2020) "Fast computation of latent correlations" \doi{10.1080/10618600.2021.1882468}.
}
