% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\docType{class}
\name{lcMethod-class}
\alias{lcMethod-class}
\alias{compose}
\alias{compose,lcMethod-method}
\alias{fit}
\alias{fit,lcMethod-method}
\alias{getLabel}
\alias{getLabel,lcMethod-method}
\alias{getName}
\alias{getName,lcMethod-method}
\alias{getShortName}
\alias{getShortName,lcMethod-method}
\alias{length,lcMethod-method}
\alias{names,lcMethod-method}
\alias{preFit}
\alias{preFit,lcMethod-method}
\alias{prepareData}
\alias{prepareData,lcMethod-method}
\alias{postFit}
\alias{postFit,lcMethod-method}
\alias{validate}
\alias{validate,lcMethod-method}
\title{lcMethod class}
\usage{
\S4method{compose}{lcMethod}(method, envir = NULL)

\S4method{fit}{lcMethod}(method, data, envir, verbose)

\S4method{getLabel}{lcMethod}(object, ...)

\S4method{getName}{lcMethod}(object)

\S4method{getShortName}{lcMethod}(object, ...)

\S4method{length}{lcMethod}(x)

\S4method{names}{lcMethod}(x)

\S4method{preFit}{lcMethod}(method, data, envir, verbose)

\S4method{prepareData}{lcMethod}(method, data, verbose)

\S4method{postFit}{lcMethod}(method, data, model, envir, verbose)

\S4method{validate}{lcMethod}(method, data, envir = NULL, ...)
}
\arguments{
\item{method}{The \code{lcMethod} object.}

\item{envir}{The \code{environment} in which the \code{lcMethod} should be evaluated}

\item{data}{The data, as a \code{data.frame}, on which the model will be trained.}

\item{verbose}{A \link[R.utils:Verbose]{R.utils::Verbose} object indicating the level of verbosity.}

\item{object}{The object to extract the label from.}

\item{...}{Additional arguments.}

\item{x}{The \code{lcMethod} object.}

\item{model}{The \code{lcModel} object returned by \code{fit()}.}
}
\value{
The updated \code{lcMethod} object.

An \code{lcModel} object.

The extracted label, as \code{character}.

A \verb{character vector} of argument names.

An \code{environment} that will be passed to \code{fit()}.

A \code{data.frame} with the post-processed data.

The updated \code{lcModel} object.

Either \code{TRUE} if all validation checks passed,
or a \code{character} containing a description of the failed validation checks.
}
\description{
Base class used to define a longitudinal cluster method. It is implemented as a wrapper around a \code{call}.

Model estimation is handled through a series of calls implement by the \code{lcMethod} object. The calls are made by \link{latrend}, in the following order:
\itemize{
\item compose
\item validate
\item prepareData
\item preFit
\item fit
\item postFit
}

Extracts the assigned label.

Extracts the name of the given \code{object}.
}
\details{
Because the \code{lcMethod} arguments may be unevaluated, evaluation functions such as \code{[[} accept an \code{envir} argument.
A default \code{environment} can be assigned or obtained from a \code{lcMethod} object using the \code{environment()} function.
}
\section{Slots}{

\describe{
\item{\code{arguments}}{A \code{list} representing the arguments of the \code{lcMethod} object. Arguments are not evaluated upon creation of the method object. Instead, arguments are stored similar to a \code{call} object. Do not modify or access.}

\item{\code{sourceCalls}}{A list of calls for tracking the original call after substitution. Used for printing objects which require too many characters (e.g. ,function definitions, matrices).}
}}

\examples{
getName(lcMethodKML("Y")) # "longitudinal k-means"
getShortName(lcMethodKML("Y")) # "KML"
m = lcMethodKML("Y")
names(m)
}
\seealso{
\link{environment}

Other lcMethod implementations: 
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}

Other lcMethod functions: 
\code{\link{[[,lcMethod-method}},
\code{\link{as.data.frame.lcMethods}()},
\code{\link{as.data.frame.lcMethod}()},
\code{\link{as.lcMethods}()},
\code{\link{as.list.lcMethod}()},
\code{\link{evaluate.lcMethod}()},
\code{\link{formula.lcMethod}()},
\code{\link{update.lcMethod}()}
}
\concept{lcMethod functions}
\concept{lcMethod implementations}
