% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R, R/model.R
\name{trajectoryAssignments}
\alias{trajectoryAssignments}
\alias{trajectoryAssignments,matrix-method}
\alias{trajectoryAssignments,lcModel-method}
\title{Get the cluster membership of each trajectory}
\usage{
\S4method{trajectoryAssignments}{matrix}(
  object,
  strategy = which.max,
  clusterNames = colnames(object),
  ...
)

\S4method{trajectoryAssignments}{lcModel}(object, strategy = which.max, ...)
}
\arguments{
\item{object}{The object to obtain the cluster assignments from.}

\item{strategy}{A function returning the cluster index based on the given vector of membership probabilities. By default, ids are assigned to the cluster with the highest probability.}

\item{clusterNames}{Optional \verb{character vector} with the cluster names. If \code{clusterNames = NULL}, \code{\link[=make.clusterNames]{make.clusterNames()}} is used.}

\item{...}{Any additional arguments passed to the strategy function.}
}
\value{
A \code{factor} indicating the cluster membership for each trajectory.
}
\description{
Classify the fitted trajectories based on the posterior probabilities computed by \code{\link[=postprob]{postprob()}}, according to a given classification strategy.

By default, trajectories are assigned based on the highest posterior probability using \code{\link[=which.max]{which.max()}}.
In cases where identical probabilities are expected between clusters, it is preferable to use \link[nnet]{which.is.max} instead, as this function breaks ties at random.
Another strategy to consider is the function \code{\link[=which.weight]{which.weight()}}, which enables weighted sampling of cluster assignments based on the trajectory-specific probabilities.
}
\details{
In case \code{object} is a \code{matrix}: the posterior probability \code{matrix}, with the \eqn{k}th column containing the observation- or trajectory-specific probability for cluster \eqn{k}.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)
trajectoryAssignments(model)

# assign trajectories at random using weighted sampling
trajectoryAssignments(model, strategy = which.weight)
}
\seealso{
\link{postprob} \link{clusterSizes} \link{predictAssignments}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric,lcModel,lcModel-method}},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()}
}
\concept{lcModel functions}
