% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/model.R
\name{fittedTrajectories}
\alias{fittedTrajectories}
\alias{fittedTrajectories,lcModel-method}
\title{Extract the fitted trajectories}
\usage{
fittedTrajectories(object, ...)

\S4method{fittedTrajectories}{lcModel}(
  object,
  at = time(object),
  what = "mu",
  clusters = trajectoryAssignments(object),
  ...
)
}
\arguments{
\item{object}{The model.}

\item{...}{For \code{lcModel}: Additional arguments passed to \link{fitted.lcModel}.}

\item{at}{The time points at which to compute the id-specific trajectories.
The default implementation merely filters the output, i.e., fitted values can only be outputted for times at which the model was trained.}

\item{what}{The distributional parameter to compute the response for.}

\item{clusters}{The cluster assignments for the strata to base the trajectories on.}
}
\value{
A \code{data.frame} representing the fitted response per trajectory per moment in time for the respective cluster.

For \code{lcModel}: A \code{data.frame} with columns id, time, response, and "Cluster".
}
\description{
Extract the fitted trajectories
}
\details{
The default \code{lcModel} implementation uses the output of \code{fitted()} of the respective model.
}
\examples{
data(latrendData)
# Note: not a great example because the fitted trajectories
# are identical to the respective cluster trajectory
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)
fittedTrajectories(model)

fittedTrajectories(model, at = time(model)[c(1, 2)])
}
\seealso{
\link{plotFittedTrajectories}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
