% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/method.R, R/model.R
\name{getName}
\alias{getName}
\alias{getShortName}
\alias{getName,lcMethod-method}
\alias{getName,NULL-method}
\alias{getShortName,lcMethod-method}
\alias{getShortName,NULL-method}
\alias{getName,lcModel-method}
\alias{getShortName,lcModel-method}
\title{Object name}
\usage{
getName(object, ...)

getShortName(object, ...)

\S4method{getName}{lcMethod}(object, ...)

\S4method{getName}{NULL}(object, ...)

\S4method{getShortName}{lcMethod}(object, ...)

\S4method{getShortName}{NULL}(object, ...)

\S4method{getName}{lcModel}(object)

\S4method{getShortName}{lcModel}(object)
}
\arguments{
\item{object}{The object.}

\item{...}{Not used.}
}
\value{
A nonempty string, as \code{character}.
}
\description{
Get the name associated with the given object.

\code{getShortName()}: Extracts the short object name
}
\details{
For \code{lcModel}: The name is determined by its associated \code{lcMethod} name and label, unless specified otherwise.
}
\section{Implementation}{

When implementing your own \code{lcMethod} subclass, override these methods to provide full and abbreviated names.
\preformatted{
setMethod("getName", "lcMethodExample", function(object) "example name")

setMethod("getShortName", "lcMethodExample", function(object) "EX")
}

Similar methods can be implemented for your \code{lcModel} subclass,
however in practice this is not needed as the names are determined by default from the \code{lcMethod} object that was used to fit the \code{lcModel} object.
}

\examples{
method <- lcMethodLMKM(Y ~ Time)
getName(method) # "lm-kmeans"
method <- lcMethodLMKM(Y ~ Time)
getShortName(method) # "LMKM"
}
\seealso{
\link{getShortName} \link{getLabel}
}
