% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{formula.lcModel}
\alias{formula.lcModel}
\title{Extract the formula of a lcModel}
\usage{
\method{formula}{lcModel}(x, what = "mu", ...)
}
\arguments{
\item{x}{The \code{lcModel} object.}

\item{what}{The distributional parameter.}

\item{...}{Additional arguments.}
}
\value{
Returns the associated \code{formula}, or \code{response ~ 0} if not specified.
}
\description{
Get the formula associated with the fitted \code{lcModel} object.
This is determined by the \code{formula} argument of the \code{lcMethod} specification that was used to fit the model.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, data = latrendData)
formula(model) # Y ~ Time
}
\seealso{
\link[stats:formula]{stats::formula}
}
