% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nodeFillingOutput.R
\name{plot.nodeFillingOutput}
\alias{plot.nodeFillingOutput}
\title{Plot a nodeFillingOutput object.}
\usage{
\method{plot}{nodeFillingOutput}(x, ...)
}
\arguments{
\item{x}{An object of type nodeFillingOutput 
returned by either nodeFilling or removeHole.}

\item{\dots}{Other arguments to be passed to 
functions plot, points, lines.}
}
\description{
Plots the boundary, all holes and 
the locations of all nodes. Should 
be used to decide if the nodes fill 
the region and are spaced closely 
enough to give good resolution in 
the plots. The only reason not to 
make the nodes too closely spaced 
is when the computing time or memory 
becomes too great.
}
\examples{
plot.new()
data(polygon1)
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.01)
plot(nodeFillingOutput)

}
\references{
Ronald P. Barry, Julie McIntyre. 
Estimating animal densities and home range in 
regions with irregular boundaries and holes: 
A lattice-based alternative to the kernel density 
estimator. Ecological Modelling 222 (2011) 1666-1672.
}
\author{
Ronald P. Barry
}
