% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dVcov2.R
\name{dVcov2}
\alias{dVcov2}
\alias{dVcov2.lm}
\alias{dVcov2.gls}
\alias{dVcov2.lme}
\alias{dVcov2.lvmfit}
\alias{dVcov2.lvmfit2}
\alias{dVcov2<-}
\alias{dVcov2<-.lm}
\alias{dVcov2<-.gls}
\alias{dVcov2<-.lme}
\alias{dVcov2<-.lvmfit}
\alias{dVcov2<-.lvmfit2}
\title{Compute the Derivative of the Information Matrix}
\usage{
dVcov2(object, ...)

\method{dVcov2}{lm}(object, adjust.residuals = FALSE, return.score = FALSE,
  ...)

\method{dVcov2}{gls}(object, cluster, vcov.param = NULL,
  adjust.residuals = FALSE, numericDerivative = FALSE,
  return.score = FALSE, ...)

\method{dVcov2}{lme}(object, cluster, vcov.param = NULL,
  adjust.residuals = FALSE, numericDerivative = FALSE,
  return.score = FALSE, ...)

\method{dVcov2}{lvmfit}(object, vcov.param = NULL, adjust.residuals = TRUE,
  numericDerivative = FALSE, return.score = FALSE, ...)

\method{dVcov2}{lvmfit2}(object, ...)

dVcov2(x, ...) <- value

\method{dVcov2}{lm}(x, ...) <- value

\method{dVcov2}{gls}(x, ...) <- value

\method{dVcov2}{lme}(x, ...) <- value

\method{dVcov2}{lvmfit}(x, ...) <- value

\method{dVcov2}{lvmfit2}(x, ...) <- value
}
\arguments{
\item{object}{a gls, lme, or lvm object.}

\item{...}{arguments to be passed to lower level methods.}

\item{adjust.residuals}{Small sample correction: should the leverage-adjusted residuals be used to compute the score? Otherwise the raw residuals will be used.}

\item{return.score}{[for internal use] export the score.}

\item{cluster}{the grouping variable relative to which the observations are iid.
Only required for gls models with no correlation argument.}

\item{vcov.param}{the variance-covariance matrix of the estimates.}

\item{numericDerivative}{If TRUE, the degree of freedom are computed using a numerical derivative.}

\item{x}{same as object.}

\item{value}{same as adjust.residuals.}
}
\description{
Compute the derivative of the information matrix.
}
