% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iid2.R
\name{iid2}
\alias{iid2}
\alias{iid2.lm}
\alias{iid2.gls}
\alias{iid2.lme}
\alias{iid2.lvmfit}
\title{Extract i.i.d. decomposition from linear and latent variable models}
\usage{
iid2(x, ...)

\method{iid2}{lm}(x, p = NULL, data = NULL, adjust.residuals = TRUE, ...)

\method{iid2}{gls}(x, p = NULL, data = NULL, adjust.residuals = TRUE, ...)

\method{iid2}{lme}(x, p = NULL, data = NULL, adjust.residuals = TRUE, ...)

\method{iid2}{lvmfit}(x, p = NULL, data = NULL, adjust.residuals = TRUE,
  ...)
}
\arguments{
\item{x}{a linear model or a latent variable model}

\item{...}{arguments to be passed to \code{score2}.}

\item{p}{[optional] the fitted parameters.}

\item{data}{[optional] the data set.}

\item{adjust.residuals}{Should the leverage-adjusted residuals be used to compute the score? Otherwise the raw residuals will be used.}
}
\value{
A matrix.
}
\description{
Extract i.i.d. decomposition from linear and latent variable models using leverage adjusted fitted residuals.
}
\details{
Leverage-adjusted residuals have been shown to improve the coverage of robust standard errors in small samples.
They are computed according to the formula:
\eqn{e_adj = \frac{e}{(1-h_{ii})^(1/2)}}
}
\examples{
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- sequence.lvm(0)
set.seed(10)
d <- sim(m,n)

## linear model
e.lm <- lm(formula.lvm,data=d)
iid.tempo <- iid2(e.lm, adjust.residuals = FALSE)
range(iid.tempo[,1:4]-iid(e.lm))

## latent variable model
e.lvm <- estimate(lvm(formula.lvm),data=d)
iid.tempo <- iid2(e.lvm, adjust.residuals = FALSE)
range(iid.tempo-iid(e.lvm))
## difference due to the use of the observed info matrix vs. the expected one.

}
\references{
Bell, R. M., & McCaffrey, D. F. Bias reduction in standard errors for linear regression with multi-stage samples. Survey Methodology, 28(2), 169-181 (2002). \cr
Kauermann G. and Carroll R. J. A note on the efficiency of sandwich covariance matrix estimation. Journal of the American Statistical Association. Vol. 96, No. 456 (2001).
}
