% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixPower.R
\name{matrixPower}
\alias{matrixPower}
\title{Power of a Matrix}
\usage{
matrixPower(x, power, symmetric, tol = 1e-12)
}
\arguments{
\item{x}{a matrix.}

\item{power}{power to be applied to the matrix.}

\item{symmetric}{is the matrix symmetric? Argument passed to the function \code{eigen}.}

\item{tol}{the threshold under which the eigenvalues are set to 0.}
}
\value{
a matrix.
}
\description{
Compute the power of a matrix.
}
\examples{
M <- matrix(rnorm(2e2),20,10)
Sigma <- var(M)
Sigma.half <- matrixPower(Sigma, power = 1/2, symmetric = FALSE)
round(crossprod(Sigma.half)-Sigma,5)

Sigma.m1 <- matrixPower(Sigma, power = -1, symmetric = FALSE)
round(Sigma.m1 \%*\% Sigma,5)

}
