% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.gls2}
\alias{summary.lme2}
\alias{summary.lvmfit2}
\title{Summary with Small Sample Correction}
\usage{
\method{summary}{gls2}(object, digit = max(3, getOption("digit")),
  adjust.residuals = TRUE, ...)

\method{summary}{lme2}(object, digit = max(3, getOption("digit")),
  adjust.residuals = TRUE, ...)

\method{summary}{lvmfit2}(object, adjust.residuals = FALSE, ...)
}
\arguments{
\item{object}{a \code{gls}, \code{lme} or \code{lvm} object.}

\item{digit}{the number of digit to keep when diplaying the summary.}

\item{adjust.residuals}{Small sample correction: should the leverage-adjusted residuals be used to compute the score? Otherwise the raw residuals will be used.}

\item{...}{arguments passed to lower level methods.}
}
\description{
Summary with small sample correction.
}
\examples{
m <- lvm(Y~X1+X2)
set.seed(10)
d <- sim(m, 2e1)

## Gold standard
summary(lm(Y~X1+X2, d))$coef

## gls models
library(nlme)
e.gls <- gls(Y~X1+X2, data = d, method = "ML")
summary(e.gls)$tTable
dVcov2(e.gls, cluster = 1:NROW(d)) <- FALSE ## no small sample correction
summary(e.gls)$tTable

dVcov2(e.gls, cluster = 1:NROW(d)) <- TRUE ## small sample correction
summary(e.gls)$tTable

## lvm models
e.lvm <- estimate(m, data = d)
summary(e.lvm)$coef
dVcov2(e.lvm) <- FALSE ## no small sample correction
summary(e.lvm)$coef

dVcov2(e.lvm) <- TRUE ## small sample correction
summary(e.lvm)$coef

}
