% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSearch.R
\name{compareSearch}
\alias{compareSearch}
\title{Compare Methods to Identify Missing Local Dependencies in a LVM}
\usage{
compareSearch(object, alpha = 0.05, method.p.adjust, statistic, trace = 1,
  ...)
}
\arguments{
\item{object}{a \code{lvm} model.}

\item{alpha}{[numeric 0-1] the significance cutoff for the p-values.
When the p-value is below, the corresponding link will be added to the model
and the search will continue. Otherwise the search will stop.}

\item{method.p.adjust}{[character] the method used to adjust the p.values for multiple comparisons.
Can be any method that is valid for the \code{stats::p.adjust} function (e.g. \code{"fdr"}).
Ignored when using the max statistic.}

\item{statistic}{[character] statistic used to perform the test.
Can the likelihood ratio test (\code{"LR"}),
the score (\code{"score"}),
or the max statistic (\code{"max"}).}

\item{trace}{[logical] should the execution of the function be traced?}

\item{...}{arguments passed to \code{\link{modelsearch2}}.}
}
\value{
A list containing:
\itemize{
\item newlink: a list containing for each \code{statistic}-\code{method.p.adjust} the local dependencies.
\item table.coef: a \code{data.frame} object containing for each \code{statistic}-\code{method.p.adjust} the estimated coefficients.
\item ls.search: a list containing for each \code{statistic}-\code{method.p.adjust} a \code{modelsearch2} object.
}
}
\description{
Compare methods to identify missing local dependencies in a LVM.
}
\details{
This function calls the \code{\link{modelsearch2}} function
to find the local dependencies.
}
\examples{
mSim <- lvm(Y~G+X1+X2)
addvar(mSim) <- ~Z1+Z2+Z3+Z4+Z5+Z6
df.data <- lava::sim(mSim, 1e2)

mBase <- lvm(Y~G)
addvar(mBase) <- ~X1+X2+Z1+Z2+Z3+Z4+Z5+Z6
e.lvm <- estimate(mBase, data = df.data)

\dontrun{
res <- compareSearch(e.lvm, statistic = c("score","Wald"),
                     method.p.adjust = c("holm","fdr","max"))
res
}
}
\concept{
modelsearch
}
