
library(lavaan.survey)

context("multiple group example")


data(HolzingerSwineford1939)


# Fit multiple group per school
fit <- lavaan(' visual  =~ x1 + x2 + c(lam31, lam31)*x3
              textual =~ x4 + x5 + c(lam62, lam62)*x6
              speed   =~ x7 + x8 + c(lam93, lam93)*x9 
             speed ~ textual 
             textual ~ visual', data=HolzingerSwineford1939,
              int.ov.free=TRUE, meanstructure=TRUE,
              auto.var=TRUE, auto.fix.first=TRUE, group="school",
              auto.cov.lv.x=TRUE, estimator="MLM")
summary(fit, fit.measures=TRUE)

# Create fictional clusters in the HS data
set.seed(20121025)
HolzingerSwineford1939$clus <- sample(1:100, size=nrow(HolzingerSwineford1939), replace=TRUE)
survey.design <- svydesign(ids=~clus, prob=~1, data=HolzingerSwineford1939)

fit.survey <- lavaan.survey(fit, survey.design)


test_that("fitmeasures, estimates, and se's match", {
  expect_equal(fitMeasures(fit.survey), structure(c(55, 0.220730045855, 132.87948760471, 53, 8.42619607421824e-09, 125.952737785577, 53, 7.09414067490144e-08, 1.05499483330744, 957.769050808683, 72, 0, 805.309827163842, 72, 0, 1.18931747571214, 0.909819057764795, 0.87749004073708, 0.87749004073708, 0.811524991146341, 0.861261451816057, 0.633984124253486, 0.911712842594126, 0.909819057764795, 0.900515805075558, 0.864851659725286, 0.864851659725286, 0.78752822792324, 0.843597167776829, 0.843597167776829, 0.917639098228852, -3690.71158393826, -3624.27184013591, 7491.42316787652, 7695.31423243771, 301, 7520.8855115104, 0.100071739831272, 0.0789553942242867, 0.121485264225017, 0.000128467791424058, 0.0956345046320678, 0.0747766283754916, 0.116689228909172, 0.000354822035576352, 0.103377388874381, 0.113244255644964, 0.0851059778570748, 0.0851059778570748, 0.0932289277017101, 0.0852593748303287, 0.0920941213262102, 0.085780549231768, 0.0926730945506326, 161.815109150158, 181.861961526302, 0.994906592265132, 0.989620980464796, 0.488241198056037, 0.875736371823938), .Names = c("npar", "fmin", "chisq", "df", "pvalue", "chisq.scaled", "df.scaled", "pvalue.scaled", "chisq.scaling.factor", "baseline.chisq", "baseline.df", "baseline.pvalue", "baseline.chisq.scaled", "baseline.df.scaled", "baseline.pvalue.scaled", "baseline.chisq.scaling.factor", "cfi", "tli", "nnfi", "rfi", "nfi", "pnfi", "ifi", "rni", "cfi.scaled", "tli.scaled", "nnfi.scaled", "rfi.scaled", "nfi.scaled", "ifi.scaled", "rni.scaled", "logl", "unrestricted.logl", "aic", "bic", "ntotal", "bic2", "rmsea", "rmsea.ci.lower", "rmsea.ci.upper", "rmsea.pvalue", "rmsea.scaled", "rmsea.ci.lower.scaled", "rmsea.ci.upper.scaled", "rmsea.pvalue.scaled", "rmr", "rmr_nomean", "srmr", "srmr_bentler", "srmr_bentler_nomean", "srmr_bollen", "srmr_bollen_nomean", "srmr_mplus", "srmr_mplus_nomean", "cn_05", "cn_01", "gfi", "agfi", "pgfi", "mfi"), class = c("lavaan.vector", "numeric")))
  
  expect_equal(coef(fit.survey), structure(c(0.539877286869993, 0.808029758527766, 1.21450073312087, 0.922774507947487, 1.12977924589256, 0.895261134146533, 0.216805367800441, 0.488091992173059, 0.542247348065866, 1.26705662887432, 0.882139383453157, 0.443775042579821, 0.463399245738806, 0.276019064105853, 0.801336673539715, 0.498188771562685, 0.704064097833635, 0.812068261156822, 0.65026690018069, 0.315873254966309, 4.94123931326923, 5.98397435897436, 2.48717948717949, 2.82264957782051, 3.99519230769231, 1.92216117012821, 4.43227425192308, 5.56314102564103, 5.41773504230769, 0.703213287232506, 0.808029758527766, 0.976064948580576, 0.922774507947488, 1.13828683603772, 0.895261134146533, 0.257040509242524, 0.665364006499502, 0.700617436285545, 0.892633649213512, 0.58520726028968, 0.310718738610895, 0.416841393419271, 0.420722438278711, 0.527286384086312, 0.389839893950567, 0.604637513064997, 0.674901959869396, 0.671949518988418, 0.479617006088213, 4.92988506, 6.2, 1.99568965517241, 3.31724137931035, 4.71206896551724, 2.46896551648276, 3.92083957793103, 5.48827586206897, 5.32720306344828), .Names = c("visual=~x2", "lam31", "textual=~x5", "lam62", "speed=~x8", "lam93", "speed~textual", "textual~visual", "x1~~x1", "x2~~x2", "x3~~x3", "x4~~x4", "x5~~x5", "x6~~x6", "x7~~x7", "x8~~x8", "x9~~x9", "visual~~visual", "textual~~textual", "speed~~speed", "x1~1", "x2~1", "x3~1", "x4~1", "x5~1", "x6~1", "x7~1", "x8~1", "x9~1", "visual=~x2.g2", "lam31", "textual=~x5.g2", "lam62", "speed=~x8.g2", "lam93", "speed~textual.g2", "textual~visual.g2", "x1~~x1.g2", "x2~~x2.g2", "x3~~x3.g2", "x4~~x4.g2", "x5~~x5.g2", "x6~~x6.g2", "x7~~x7.g2", "x8~~x8.g2", "x9~~x9.g2", "visual~~visual.g2", "textual~~textual.g2", "speed~~speed.g2", "x1~1.g2", "x2~1.g2", "x3~1.g2", "x4~1.g2", "x5~1.g2", "x6~1.g2", "x7~1.g2", "x8~1.g2", "x9~1.g2"), class = c("lavaan.vector", "numeric")))
  
  expect_equal(sqrt(diag(vcov(fit.survey))), structure(c(0.130262067056868, 0.129907370855504, 0.12135586268879, 0.0669179087709049, 0.265926305981137, 0.106861553046438, 0.0678113717572, 0.134833250292687, 0.147791038109318, 0.159008655283259, 0.1222151512387, 0.0749956588909299, 0.0972416302753267, 0.0592158662888981, 0.122420842730072, 0.117121855976792, 0.1073418006397, 0.209954956429557, 0.12297871564236, 0.0978595648257758, 0.0961289190011843, 0.0938617383139541, 0.0949296885569688, 0.0911115275586502, 0.104537053750512, 0.0846232808597408, 0.0802250284465027, 0.0854411882168526, 0.0718234724151165, 0.141831888000241, 0.129907370855504, 0.0910631703320131, 0.0669179087709049, 0.163509969705846, 0.106861553046438, 0.0953249692075382, 0.145416781406208, 0.20433297168295, 0.136299462549557, 0.0995179234118444, 0.0647879986728121, 0.0687130583214251, 0.0700020410725995, 0.0765049234132245, 0.115070038963284, 0.0954710846257327, 0.169565345095088, 0.124620286985819, 0.103032033978479, 0.0839747109951186, 0.0827461948413694, 0.0908029408431624, 0.0959966726063048, 0.0996217254342966, 0.0946204605407226, 0.0824895664439666, 0.0981343428938682, 0.0812912107336626), .Names = c("visual=~x2", "lam31", "textual=~x5", "lam62", "speed=~x8", "lam93", "speed~textual", "textual~visual", "x1~~x1", "x2~~x2", "x3~~x3", "x4~~x4", "x5~~x5", "x6~~x6", "x7~~x7", "x8~~x8", "x9~~x9", "visual~~visual", "textual~~textual", "speed~~speed", "x1~1", "x2~1", "x3~1", "x4~1", "x5~1", "x6~1", "x7~1", "x8~1", "x9~1", "visual=~x2.g2", "lam31", "textual=~x5.g2", "lam62", "speed=~x8.g2", "lam93", "speed~textual.g2", "textual~visual.g2", "x1~~x1.g2", "x2~~x2.g2", "x3~~x3.g2", "x4~~x4.g2", "x5~~x5.g2", "x6~~x6.g2", "x7~~x7.g2", "x8~~x8.g2", "x9~~x9.g2", "visual~~visual.g2", "textual~~textual.g2", "speed~~speed.g2", "x1~1.g2", "x2~1.g2", "x3~1.g2", "x4~1.g2", "x5~1.g2", "x6~1.g2", "x7~1.g2", "x8~1.g2", "x9~1.g2")))
})

