% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa_fit_plot.R
\name{cfa_fit_plot}
\alias{cfa_fit_plot}
\title{Fit and plot CFA simultaneously}
\usage{
cfa_fit_plot(
  model,
  data,
  covs = FALSE,
  estimator = "MLR",
  remove.items = "",
  print = TRUE,
  save.as.pdf = FALSE,
  file.name,
  ...
)
}
\arguments{
\item{model}{CFA model to fit.}

\item{data}{Data set on which to fit the CFA model.}

\item{covs}{Logical, whether to include covariances on the lavaan plot.}

\item{estimator}{What estimator to use for the CFA.}

\item{remove.items}{Optional, if one wants to remove items from the CFA model
without having to redefine it completely again.}

\item{print}{Logical, whether to print model summary to console.}

\item{save.as.pdf}{Logical, whether to save as PDF for a high-resolution,
scalable vector graphic quality plot. Defaults to
saving to the "/model" subfolder of the working
directory. If it doesn't exist, it creates it. Then
automatically open the created PDF in the default
browser. Defaults to false.}

\item{file.name}{Optional (when \code{save.as.pdf} is set to \code{TRUE}), if one
wants something different than the default file name.
It saves to pdf per default, so the .pdf extension
should not be specified as it will add it automatically.}

\item{...}{Arguments to be passed to function \link[lavaan:cfa]{lavaan::cfa}.}
}
\value{
The function returns a \code{lavaan} fit object. However, it also: prints
a summary of the \code{lavaan} fit object to the console, and; prints a
\code{lavaanPlot} of the \code{lavaan} fit object.
}
\description{
Prints and saves CFA fit, as well as plots CFA factor loadings,
simultaneously.
}
\section{Illustrations}{


\if{html}{
\figure{cfaplot.png}{options: width="400"}
}
}

\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE) && requireNamespace("lavaanPlot", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
(latent <- list(
  visual = paste0("x", 1:3),
  textual = paste0("x", 4:6),
  speed = paste0("x", 7:9)
))

HS.model <- write_lavaan(latent = latent)
cat(HS.model)

library(lavaan)
fit <- cfa_fit_plot(HS.model, HolzingerSwineford1939)
\dontshow{\}) # examplesIf}
}
\keyword{CFA}
\keyword{fit}
\keyword{lavaan}
\keyword{plot}
