% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/planepoint.R
\name{lawn_planepoint}
\alias{lawn_planepoint}
\title{Calculate a Planepoint}
\usage{
lawn_planepoint(pt, triangle, lint = FALSE)
}
\arguments{
\item{pt}{the Point for which a z-value will be calculated}

\item{triangle}{a Polygon feature with three vertices}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
the z-value for pt (numeric)
}
\description{
Takes a triangular plane as a \code{\link{data-Polygon}} and a
\code{\link{data-Point}} within that triangle and returns the
z-value at that point
}
\details{
The Polygon needs to have properties a, b, and c that define
the values at its three corners.
}
\examples{
pt <- lawn_point(c(-75.3221, 39.529))
triangle <- '{
  "type": "Feature",
  "properties": {
    "a": 11,
    "b": 122,
    "c": 44
  },
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-75.1221, 39.57],
      [-75.58, 39.18],
      [-75.97, 39.86],
      [-75.1221, 39.57]
    ]]
  }
}'
lawn_planepoint(pt, triangle)
}
\seealso{
Other interpolation: \code{\link{lawn_hex_grid}};
  \code{\link{lawn_isolines}};
  \code{\link{lawn_point_grid}};
  \code{\link{lawn_square_grid}}; \code{\link{lawn_tin}};
  \code{\link{lawn_triangle_grid}}
}

