% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroid.R
\name{lawn_centroid}
\alias{lawn_centroid}
\title{Centroid}
\usage{
lawn_centroid(features, lint = FALSE)
}
\arguments{
\item{features}{Input features}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
Feature - centroid of the input features
}
\description{
Takes one or more features and calculates the centroid using the arithmetic
mean of all vertices. This lessens the effect of small islands and artifacts
when calculating the centroid of a set of polygons.
}
\examples{
poly <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [105.818939,21.004714],
      [105.818939,21.061754],
      [105.890007,21.061754],
      [105.890007,21.004714],
      [105.818939,21.004714]
     ]]
  }
}'
lawn_centroid(features = poly)
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bbox}}, \code{\link{lawn_bearing}},
  \code{\link{lawn_center}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_square}}
}

