% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linestring.R
\name{lawn_linestring}
\alias{lawn_linestring}
\title{Create a linestring}
\usage{
lawn_linestring(coordinates, properties = NULL)
}
\arguments{
\item{coordinates}{A list of Positions}

\item{properties}{A list of properties}
}
\value{
a \code{\link{data-LineString}} feature
}
\description{
Create a linestring
}
\examples{
linestring1 <- '[
   [-21.964416, 64.148203],
   [-21.956176, 64.141316],
   [-21.93901, 64.135924],
   [-21.927337, 64.136673]
]'
linestring2 <- '[
   [-21.929054, 64.127985],
   [-21.912918, 64.134726],
   [-21.916007, 64.141016],
   [-21.930084, 64.14446]
]'
lawn_linestring(linestring1)
lawn_linestring(linestring2)

pts <- list(
   c(-21.964416, 64.148203),
   c(-21.956176, 64.141316),
   c(-21.93901, 64.135924),
   c(-21.927337, 64.136673)
)
lawn_linestring(pts, properties = list(name = 'line1', distance = 145))

# completely non-sensical, but gets some data quickly
pts <- lawn_random()$features$geometry$coordinates
lawn_linestring(pts)
}
\seealso{
Other data functions: \code{\link{lawn_featurecollection}},
  \code{\link{lawn_feature}}, \code{\link{lawn_filter}},
  \code{\link{lawn_geometrycollection}},
  \code{\link{lawn_multilinestring}},
  \code{\link{lawn_multipoint}},
  \code{\link{lawn_multipolygon}},
  \code{\link{lawn_point}}, \code{\link{lawn_polygon}},
  \code{\link{lawn_random}}, \code{\link{lawn_remove}},
  \code{\link{lawn_sample}}
}

