% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersect.R
\name{lawn_intersect}
\alias{lawn_intersect}
\title{Intersection}
\usage{
lawn_intersect(poly1, poly2, lint = FALSE)
}
\arguments{
\item{poly1}{A \link{data-Polygon}.}

\item{poly2}{A \link{data-Polygon}.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
\link{data-Polygon}, \link{data-MultiLineString}, or undefined
}
\description{
Finds the intersection of two \link{data-Polygon}'s and returns just
the intersection of the two
}
\details{
Polygons with just a shared boundary will return the boundary.
Polygons that do not intersect will return \code{NULL}.
}
\examples{
poly1 <- '{
 "type": "Feature",
 "properties": {
   "fill": "#0f0"
 },
 "geometry": {
   "type": "Polygon",
   "coordinates": [[
     [-122.801742, 45.48565],
     [-122.801742, 45.60491],
     [-122.584762, 45.60491],
     [-122.584762, 45.48565],
     [-122.801742, 45.48565]
    ]]
 }
}'

poly2 <- '{
 "type": "Feature",
 "properties": {
   "fill": "#00f"
 },
 "geometry": {
   "type": "Polygon",
   "coordinates": [[
     [-122.520217, 45.535693],
     [-122.64038, 45.553967],
     [-122.720031, 45.526554],
     [-122.669906, 45.507309],
     [-122.723464, 45.446643],
     [-122.532577, 45.408574],
     [-122.487258, 45.477466],
     [-122.520217, 45.535693]
     ]]
 }
}'
lawn_intersect(poly1, poly2)

\dontrun{
view(poly1)
view(poly2)
lawn_intersect(poly1, poly2) \%>\% view()

x1 <- lawn_buffer(lawn_point(c(-122.6375, 45.53)), 1500, "meters")
x2 <- lawn_buffer(lawn_point(c(-122.6475, 45.53)), 1500, "meters")
lawn_intersect(x1, x2)
as.fc(x1) \%>\% view()
as.fc(x2) \%>\% view()
lawn_intersect(x1, x2) \%>\% view()

# not overlapping
x3 <- lawn_buffer(lawn_point(c(-122.6375, 45.53)), 1500, "meters")
x4 <- lawn_buffer(lawn_point(c(-122.6975, 45.53)), 1500, "meters")
as.fc(x3) \%>\% view()
as.fc(x4) \%>\% view()
lawn_intersect(x3, x4) \%>\% view()
}
}
\seealso{
Other transformations: \code{\link{lawn_bezier}},
  \code{\link{lawn_buffer}}, \code{\link{lawn_concave}},
  \code{\link{lawn_convex}}, \code{\link{lawn_difference}},
  \code{\link{lawn_merge}}, \code{\link{lawn_simplify}},
  \code{\link{lawn_union}}
}
\author{
Jeff Hollister \email{hollister.jeff@epa.gov}
}
