% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lazy.insert.code.R
\name{lazy.insert.code}
\alias{lazy.insert.code}
\title{Insert Code to a TeX or HTML document}
\usage{
lazy.insert.code(file, prompt.symbol = options()$prompt, lines)
}
\arguments{
\item{file}{Filename containing the code to be inserted}

\item{prompt.symbol}{Character to be placed at the left most side
of the page.  Defaults to the system's current prompt symbol}

\item{lines}{A vector giving the lines in \code{file} to be
  inserted into the document}
}
\description{
Places TeX code from a file into a TeX document.
Text is placed within a verbatim environment.  For HTML documents,
a verbatim-like environment is created
}
\details{
Text is inserted in a verbatim environment to preserve
  whitespace.  This function is performed better by \code{Sweave}
  and \code{knitr}.  Those packages will also display any result
  printed by the code.  This function will not display results.

  With HTML, the font family is set to monospace, and the font is
  set to courier.  All of the spaces are replaced with a
  non-breaking space to preserve the white space in the code.
}
\author{
Benjamin Nutter
}

