% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.significant.R
\name{is_significant}
\alias{is_significant}
\title{Test the significance of a p-value}
\usage{
is_significant(pvalue, alpha = 0.05)
}
\arguments{
\item{pvalue}{The p-value to be tested}

\item{alpha}{The significance level for comparison}
}
\description{
Test if a p-value is significant.  This is specifically designed
  to handle numeric output, or output from \code{\link{pvalString}}
}
\details{
In instances where \code{pvalue} has a leading '<' or '>',
  the inequality is stripped and the remaining characters are coerced to
  a numeric.  A logical vector comparing pvalue to alpha is returned 
  where the value is \code{TRUE} if \code{pvalue} <= \code{alpha}
  
  This function was built with the intent of using it to identify rows 
  in descriptive tables (such as \code{cattable} and \code{conttable}) 
  with significant results.  These rows could then be highlighted
  using bold print automatically.  This might prove useful for large tables.
}
\examples{
\dontrun{
is_significant(c(.10, .06, .051, .05, .049, .02, .01))
is_significant(c("> .10", "< .05", "< 0.001"), alpha=.01)
}

}
\author{
Benjamin Nutter
}
