% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lazy.R
\name{lazy_}
\alias{lazy}
\alias{lazy_}
\title{Capture expression for later lazy evaluation.}
\usage{
lazy_(expr, env)

lazy(expr, env = parent.frame(), .follow_symbols = TRUE)
}
\arguments{
\item{expr}{Expression to capture. For \code{lazy_} must be a name
or a call.}

\item{env}{Environment in which to evaluate expr.}

\item{.follow_symbols}{If \code{TRUE}, the default, follows promises across
function calls. See \code{vignette("chained-promises")} for details.}
}
\description{
\code{lazy()} uses non-standard evaluation to turn promises into lazy
objects; \code{lazy_()} does standard evaluation and is suitable for
programming.
}
\details{
Use \code{lazy()} like you'd use \code{\link{substitute}()}
to capture an unevaluated promise. Compared to \code{substitute()} it
also captures the environment associated with the promise, so that you
can correctly replay it in the future.
}
\examples{
lazy_(quote(a + x), globalenv())

# Lazy is designed to be used inside a function - you should
# give it the name of a function argument (a promise)
f <- function(x = b - a) {
  lazy(x)
}
f()
f(a + b / c)

# Lazy also works when called from the global environment. This makes
# easy to play with interactively.
lazy(a + b / c)

# By default, lazy will climb all the way back to the initial promise
# This is handy if you have if you have nested functions:
g <- function(y) f(y)
h <- function(z) g(z)
f(a + b)
g(a + b)
h(a + b)

# To avoid this behavour, set .follow_symbols = FALSE
# See vignette("chained-promises") for details
}

