% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_new}
\alias{call_new}
\title{Create a call by "hand"}
\usage{
call_new(f, ..., .args = list())
}
\arguments{
\item{f}{Function to call. For \code{make_call}, either a string, a symbol
or a quoted call. For \code{do_call}, a bare function name or call.}

\item{..., .args}{Arguments to the call either in or out of a list}
}
\description{
Create a call by "hand"
}
\examples{
# f can either be a string, a symbol or a call
call_new("f", a = 1)
call_new(quote(f), a = 1)
call_new(quote(f()), a = 1)

#' Can supply arguments individually or in a list
call_new(quote(f), a = 1, b = 2)
call_new(quote(f), .args = list(a = 1, b = 2))
}

