% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_macroeconomic_event.R
\name{evaluate_macroeconomic_event}
\alias{evaluate_macroeconomic_event}
\title{Function used to evaluate market type situation by reading the file with Macroeconomic Events
and writing a trigger to the trading robot}
\usage{
evaluate_macroeconomic_event(setup_file_path,
  setup_file_name = "Setup.csv", macro_event_path,
  macro_file_name = "01_MacroeconomicEvent.csv", path_T1, path_T3)
}
\arguments{
\item{setup_file_path}{string, path to the folder with Setup.csv file}

\item{setup_file_name}{string, name of the file 'Setup.csv'}

\item{macro_event_path}{string, path to the folder with a file '01_MacroeconomicEvent.csv'}

\item{macro_file_name}{string, name of the file '01_MacroeconomicEvent.csv'}

\item{path_T1}{Path of the Terminal 1}

\item{path_T3}{Path of the Terminal 3}
}
\value{
Function will write files indicating to enable or disable trading systems to open new orders
}
\description{
Function is reading the content of the file 01_MacroeconomicEvent.csv.
Content of the file can be either 1 or 0.
1 - when Macro Economic event is present, 0 - when it's not.
Function will also read magic number of the trading robots. This is indicated in the file 'Setup.csv'.
Final outcome of the function is the series of files written to the destination directories.
These files will either enable or disable opening of new positions in the trading robots
#'
}
\details{
This function is used exclusively with Market Type recognition system.

Final evaluation will consist in writing a dedicated file with a simple information:

When Macro economic even is not present:

"Magic","IsEnabled"
8139125,1

or, when Macro economic event is present:

"Magic","IsEnabled"
8139125,0
}
\examples{

# evaluate data on macroeconomic event (required to start trading)
library(dplyr)
library(readr)

dir <- normalizePath(tempdir(),winslash = "/")

evaluate_macroeconomic_event(setup_file_path = system.file('extdata', package = "lazytrade"),
                             setup_file_name = "Setup.csv",
                             macro_event_path = system.file('extdata', package = "lazytrade"),
                             macro_file_name = "01_MacroeconomicEvent.csv",
                             path_T1 = dir, path_T3 = dir)



}
