% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_data}
\alias{import_data}
\title{Import Data file with Trade Logs to R.}
\usage{
import_data(path_terminal, trade_log_file, demo_mode = FALSE)
}
\arguments{
\item{path_terminal}{- path of the Trading Terminal where the file with data is written}

\item{trade_log_file}{- File name where the order results are written}

\item{demo_mode}{- When true function uses data stored in the package data folder}
}
\value{
Function will return the dataframe with trade data and automatically set proper column types
}
\description{
Function is capable to import file with executed trades log.
Files do not have column headers hence function will take care to name columns as well as to perform relevant cleansing
}
\examples{

library(lazytrade)
library(dplyr)
library(readr)
library(lubridate)
DFT1 <- import_data(trade_log_file = system.file("extdata",
                                                 "OrdersResultsT1.csv",
                                                 package = "lazytrade"),
                    demo_mode = TRUE)



}
\author{
(C) 2019 Vladimir Zhbanko
}
