% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aml_simulation.R
\name{aml_simulation}
\alias{aml_simulation}
\title{Function to simulate multiple input structures}
\usage{
aml_simulation(
  timeframe = 60,
  path_sim_input,
  path_sim_result,
  par_simulate1 = 10,
  par_simulate2 = 16,
  demo_mode = FALSE
)
}
\arguments{
\item{timeframe}{Integer, Data timeframe e.g. 60 min. This will be equal to 1 bar}

\item{path_sim_input}{String, Path to the folder where csv files will be placed, typically AI_RSIADXAUDCAD60.csv}

\item{path_sim_result}{String, Path to the folder where all results from simulations shall be written}

\item{par_simulate1}{Integer, Parameter that can be used in simulation}

\item{par_simulate2}{Integer, Parameter that can be used in simulation}

\item{demo_mode}{Boolean, Simplify function test. When TRUE no simulation will be made}
}
\value{
Function is writing file into Decision Support System folders
}
\description{
Function is designed to evaluate several different inputs.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Function is using several other functions to perform sets of operations
designed to test several inputs. Designed to validate model settings.

Update: New function structure to allow quicker simulation of parameters to find best performing input
}
\examples{

\donttest{

library(dplyr)
library(magrittr)
library(readr)
library(h2o)
library(lazytrade)
library(lubridate)
library(stats)

path_input <- normalizePath(tempdir(),winslash = "/")
path_sim_input <- file.path(path_input, "path_sim_input")
dir.create(path_sim_input)
path_sim_result <- file.path(path_input, "path_sim_result")
dir.create(path_sim_result)

file.copy(from = system.file("extdata", "AI_RSIADXCADCHF60.csv", package = "lazytrade"),
          to = file.path(path_sim_input, "AI_RSIADXCADCHF60.csv"), overwrite = TRUE)
file.copy(from = system.file("extdata", "AI_RSIADXEURNZD60.csv", package = "lazytrade"),
          to = file.path(path_sim_input, "AI_RSIADXEURNZD60.csv"), overwrite = TRUE)

# start h2o engine
h2o.init(nthreads = 2)

# simulation of different epoch values
aml_simulation(timeframe = 60,
               path_sim_input = path_sim_input,
               path_sim_result = path_sim_result,
               par_simulate1 = 10,
               par_simulate2 = 10,
               demo_mode = FALSE)

Sys.sleep(5)
# stop h2o engine
h2o.shutdown(prompt = FALSE)

#set delay to insure h2o unit closes properly before the next test
Sys.sleep(5)

}



}
\author{
(C) 2021 Vladimir Zhbanko
}
