% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDAPrototype.R
\name{LDAPrototype}
\alias{LDAPrototype}
\title{Determine the Prototype LDA}
\usage{
LDAPrototype(
  docs,
  vocabLDA,
  vocabMerge = vocabLDA,
  n = 100,
  seeds,
  id = "LDARep",
  pm.backend,
  ncpus,
  limit.rel,
  limit.abs,
  atLeast,
  progress = TRUE,
  keepTopics = FALSE,
  keepSims = FALSE,
  keepLDAs = FALSE,
  ...
)
}
\arguments{
\item{docs}{[\code{list}]\cr
Documents as received from \code{\link[tosca]{LDAprep}}.}

\item{vocabLDA}{[\code{character}]\cr
Vocabularies passed to \code{\link[lda]{lda.collapsed.gibbs.sampler}}.}

\item{vocabMerge}{[\code{character}]\cr
Vocabularies taken into consideration for merging topic matrices.}

\item{n}{[\code{integer(1)}]\cr
Number of Replications.}

\item{seeds}{[\code{integer(n)}]\cr
Random Seeds for each Replication.}

\item{id}{[\code{character(1)}]\cr
Name for the computation.}

\item{pm.backend}{[\code{character(1)}]\cr
One of "multicore", "socket" or "mpi".
If \code{pm.backend} is set, \code{\link[parallelMap]{parallelStart}} is
called before computation is started and \code{\link[parallelMap]{parallelStop}}
is called after.}

\item{ncpus}{[\code{integer(1)}]\cr
Number of (physical) CPUs to use. If \code{pm.backend} is passes,
default is determined by \code{\link[future]{availableCores}}.}

\item{limit.rel}{[0,1]\cr
See \code{\link{jaccardTopics}}. Default is \code{1/500}.}

\item{limit.abs}{[\code{integer(1)}]\cr
See \code{\link{jaccardTopics}}. Default is \code{10}.}

\item{atLeast}{[\code{integer(1)}]\cr
See \code{\link{jaccardTopics}}. Default is \code{0}.}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown for the steps of \code{\link{mergeTopics}}
and \code{\link{jaccardTopics}}? Turning it off, could lead to significantly
faster calculation. Default ist \code{TRUE}.}

\item{keepTopics}{[\code{logical(1)}]\cr
Should the merged topic matrix from \code{\link{mergeTopics}} be kept?}

\item{keepSims}{[\code{logical(1)}]\cr
Should the calculated topic similarities matrix from \code{\link{jaccardTopics}} be kept?}

\item{keepLDAs}{[\code{logical(1)}]\cr
Should the considered LDAs be kept?}

\item{...}{additional arguments passed to \code{\link[lda]{lda.collapsed.gibbs.sampler}}.
Arguments will be coerced to a vector of length \code{n}.}
}
\value{
[\code{named list}] with entries
 \describe{
  \item{\code{lda}}{List of \code{\link{LDA}} objects of the determined Prototype LDA
  and - if \code{keepLDAs} is \code{TRUE} - all considered LDAs.}
  \item{\code{protoid}}{[\code{character(1)}] Name (ID) of the determined Prototype LDA.}
  \item{\code{id}}{[\code{character(1)}] See above.}
  \item{\code{param}}{[\code{named list}] with parameter specifications for
  \code{limit.rel} [0,1], \code{limit.abs} [\code{integer(1)}] and
  \code{atLeast} [\code{integer(1)}] See above for explanation.}
  \item{\code{topics}}{[\code{named matrix}] with the count of vocabularies
  (row wise) in topics (column wise).}
  \item{\code{sims}}{[\code{lower triangular named matrix}] with all pairwise
  jaccard similarities of the given topics.}
  \item{\code{wordslimit}}{[\code{integer}] with counts of words determined as
  relevant based on \code{limit.rel} and \code{limit.abs}.}
  \item{\code{wordsconsidered}}{[\code{integer}] with counts of considered
  words for similarity calculation. Could differ from \code{wordslimit}, if
  \code{atLeast} is greater than zero.}
  \item{\code{sclop}}{[\code{symmetrical named matrix}] with all pairwise
  S-CLOP scores of the given LDA runs.}
}
}
\description{
Performs multiple runs of LDA and returns the Prototype LDA of
this set of LDAs.
}
\details{
While \code{LDAPrototype} marks the overall shortcut for performing
multiple LDA runs and choosing the Prototype of them, \code{\link{getPrototype}}
just hooks up at determining the Prototype. The generation of multiple LDAs
has to be done before use of \code{getPrototype}.

To save memory a lot of interim calculations are discarded by default.

If you use parallel computation, no progress bar is shown.

For details see the details sections of the workflow functions at \code{\link{getPrototype}}.
}
\examples{
res = LDAPrototype(docs = reuters_docs, vocabLDA = reuters_vocab,
   n = 4, K = 10, num.iterations = 30)
res
getPrototype(res) # = getLDA(res)
getSCLOP(res)

res = LDAPrototype(docs = reuters_docs, vocabLDA = reuters_vocab,
   n = 4, K = 10, num.iterations = 30, keepLDAs = TRUE)
res
getLDA(res, all = TRUE)
getPrototypeID(res)
getParam(res)

}
\seealso{
Other shortcut functions: 
\code{\link{getPrototype}()}

Other PrototypeLDA functions: 
\code{\link{getPrototype}()},
\code{\link{getSCLOP}()}

Other replication functions: 
\code{\link{LDARep}()},
\code{\link{as.LDARep}()},
\code{\link{getJob}()},
\code{\link{mergeRepTopics}()}
}
\concept{PrototypeLDA functions}
\concept{replication functions}
\concept{shortcut functions}
