% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDARep.R
\name{LDARep}
\alias{LDARep}
\title{LDA Replications}
\usage{
LDARep(docs, vocab, n = 100, seeds, id = "LDARep", pm.backend, ncpus, ...)
}
\arguments{
\item{docs}{[\code{list}]\cr
Documents as received from \code{\link[tosca]{LDAprep}}.}

\item{vocab}{[\code{character}]\cr
Vocabularies passed to \code{\link[lda]{lda.collapsed.gibbs.sampler}}.}

\item{n}{[\code{integer(1)}]\cr
Number of Replications.}

\item{seeds}{[\code{integer(n)}]\cr
Random Seeds for each Replication.}

\item{id}{[\code{character(1)}]\cr
Name for the computation.}

\item{pm.backend}{[\code{character(1)}]\cr
One of "multicore", "socket" or "mpi".
If \code{pm.backend} is set, \code{\link[parallelMap]{parallelStart}} is
called before computation is started and \code{\link[parallelMap]{parallelStop}}
is called after.}

\item{ncpus}{[\code{integer(1)}]\cr
Number of (physical) CPUs to use. If \code{pm.backend} is passes,
default is determined by \code{\link[future]{availableCores}}.}

\item{...}{additional arguments passed to \code{\link[lda]{lda.collapsed.gibbs.sampler}}.
Arguments will be coerced to a vector of length \code{n}.}
}
\value{
[\code{named list}] with entries \code{id} for computation's name,
\code{jobs} for the parameter settings and \code{lda} for the results itself.
}
\description{
Performs multiple runs of Latent Dirichlet Allocation.
}
\details{
The function generates multiple LDA runs with the possability of
using parallelization. The integration is done by the
\code{\link[parallelMap:parallelMap]{parallelMap-package}}.

The function returns a \code{LDARep} object. You can receive results and
all other elements of this object with getter functions (see \code{\link{getJob}}).
}
\examples{
res = LDARep(docs = reuters_docs, vocab = reuters_vocab, n = 4, seeds = 1:4,
   id = "myComputation", K = 7:10, alpha = 1, eta = 0.01, num.iterations = 20)
res
getJob(res)
getID(res)
getLDA(res, 4)

\donttest{
LDARep(docs = reuters_docs, vocab = reuters_vocab,
   K = 10, num.iterations = 100, pm.backend = "socket")
}

}
\seealso{
Other replication functions: 
\code{\link{LDAPrototype}()},
\code{\link{as.LDARep}()},
\code{\link{getJob}()},
\code{\link{mergeRepTopics}()}

Other LDA functions: 
\code{\link{LDABatch}()},
\code{\link{LDA}()},
\code{\link{getTopics}()}

Other workflow functions: 
\code{\link{SCLOP}()},
\code{\link{dendTopics}()},
\code{\link{getPrototype}()},
\code{\link{jaccardTopics}()},
\code{\link{mergeTopics}()}
}
\concept{LDA functions}
\concept{replication functions}
\concept{workflow functions}
