% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldaPrototype-package.R
\docType{package}
\name{ldaPrototype-package}
\alias{ldaPrototype}
\alias{ldaPrototype-package}
\title{ldaPrototype: Prototype of Multiple Latent Dirichlet Allocation Runs}
\description{
Determine a Prototype from a number of runs of Latent Dirichlet
Allocation (LDA) measuring its similarities with S-CLOP: A procedure to select
the LDA run with highest mean pairwise similarity, which is measured by S-CLOP
(Similarity of multiple sets by Clustering with Local Pruning), to all other
runs. LDA runs are specified by its assignments leading to estimators for
distribution parameters. Repeated runs lead to different results, which we
encounter by choosing the most representative LDA run as prototype.\cr
For bug reports and feature requests please use the issue tracker:
\url{https://github.com/JonasRieger/ldaPrototype/issues}.
}
\section{Data}{

\code{\link{reuters}} Example Dataset (91 articles from Reuters) for testing.
}

\section{Constructor}{

\code{\link{LDA}} LDA objects used in this package.\cr
\code{\link{as.LDARep}} LDARep objects.\cr
\code{\link{as.LDABatch}} LDABatch objects.
}

\section{Getter}{

\code{\link{getTopics}} Getter for \code{\link{LDA}} objects.\cr
\code{\link{getJob}} Getter for \code{\link{LDARep}} and \code{\link{LDABatch}} objects.\cr
\code{\link{getSimilarity}} Getter for \code{\link[=jaccardTopics]{TopicSimilarity}} objects.\cr
\code{\link{getSCLOP}} Getter for \code{\link[=getPrototype]{PrototypeLDA}} objects.\cr
\code{\link{getPrototype}} Determine the Prototype LDA.
}

\section{Performing multiple LDAs}{

\code{\link{LDARep}} Performing multiple LDAs locally (using parallelization).\cr
\code{\link{LDABatch}} Performing multiple LDAs on Batch Systems.
}

\section{Calculation Steps (Workflow) to determine the Prototype LDA}{

\code{\link{mergeTopics}} Merge topic matrices from multiple LDAs.\cr
\code{\link{jaccardTopics}} Calculate topic similarities.\cr
\code{\link{dendTopics}} Create a dendrogram from topic similarities.\cr
\code{\link{SCLOP}} Determine various S-CLOP values.\cr
\code{\link{pruneSCLOP}} Prune \code{\link[=dendTopics]{TopicDendrogram}} objects.
}

\section{Shortcuts}{

\code{\link{getPrototype}} Shortcut which includes all calculation steps.\cr
\code{\link{LDAPrototype}} Shortcut which performs multiple LDAs and
determines their Prototype.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/JonasRieger/ldaPrototype}
  \item \url{https://doi.org/10.5281/zenodo.3597978}
  \item Report bugs at \url{https://github.com/JonasRieger/ldaPrototype/issues}
}

}
\author{
\strong{Maintainer}: Jonas Rieger \email{jonas.rieger@tu-dortmund.de} (\href{https://orcid.org/0000-0002-0007-4478}{ORCID})

}
